/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.auth.message.config;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.UUID;
import javax.security.auth.message.AuthException;
import javax.security.auth.message.config.AuthConfigFactory;
import javax.security.auth.message.config.AuthConfigProvider;
import javax.security.auth.message.config.RegistrationListener;
import org.jboss.logging.Logger;
import org.jboss.security.auth.message.config.SecurityActions;

public class AuthProviderRegistrationDelegate {
    private static Logger log = Logger.getLogger(AuthProviderRegistrationDelegate.class);
    private Map keyProviderMap = new HashMap();
    private Map keyListenerMap = new HashMap();
    private Map idToDescriptionMap = new HashMap();
    private Map idKeyMap = new HashMap();
    private Map providerToIDListMap = new HashMap();

    public String[] detachListener(RegistrationListener listener, String layer, String appContext) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        String[] arr = new String[]{};
        String input = (layer + "_" + appContext).toUpperCase();
        String allLayer = ("NULL_" + appContext).toUpperCase();
        String allContext = (layer + "_" + "NULL").toUpperCase();
        String general = "NULL_NULL";
        RegistrationListener origListener = null;
        String key = null;
        for (int i = 0; i < 4 && origListener == null; ++i) {
            if (i == 0) {
                key = input;
            }
            if (i == 1) {
                key = allLayer;
            }
            if (i == 2) {
                key = allContext;
            }
            if (i == 3) {
                key = general;
            }
            origListener = (RegistrationListener)this.keyListenerMap.get(key);
        }
        if (origListener == listener) {
            this.keyListenerMap.remove(key);
            AuthConfigProvider provider = (AuthConfigProvider)this.keyProviderMap.get(key);
            if (provider != null) {
                List list = (List)this.providerToIDListMap.get(provider);
                arr = new String[list.size()];
                list.toArray(arr);
            }
        }
        return arr;
    }

    public AuthConfigProvider getConfigProvider(String layer, String appContext, RegistrationListener listener) {
        if (appContext == null) {
            appContext = " ";
        }
        String input = (layer + "_" + appContext).toUpperCase();
        String allLayer = ("NULL_" + appContext).toUpperCase();
        String allContext = (layer + "_" + "NULL").toUpperCase();
        String general = "NULL_NULL";
        AuthConfigProvider acp = null;
        String key = null;
        for (int i = 0; i < 4 && acp == null; ++i) {
            if (i == 0) {
                key = input;
            }
            if (i == 1) {
                key = allLayer;
            }
            if (i == 2) {
                key = allContext;
            }
            if (i == 3) {
                key = general;
            }
            acp = (AuthConfigProvider)this.keyProviderMap.get(key);
        }
        if (acp != null && listener != null) {
            this.keyListenerMap.put(key, listener);
        }
        return acp;
    }

    public AuthConfigFactory.RegistrationContext getRegistrationContext(String registrationID) {
        final String description = (String)this.idToDescriptionMap.get(registrationID);
        String key = (String)this.idKeyMap.get(registrationID);
        StringTokenizer st = new StringTokenizer(key, "_");
        if (st.countTokens() < 2) {
            throw new IllegalStateException("Invalid key obtained=" + key);
        }
        final String layer = st.nextToken();
        final String appCtx = st.nextToken();
        return new AuthConfigFactory.RegistrationContext(){

            public String getAppContext() {
                return appCtx.equals("NULL") ? null : appCtx;
            }

            public String getDescription() {
                return description;
            }

            public String getMessageLayer() {
                return layer.equals("NULL") ? null : layer;
            }

            public boolean isPersistent() {
                return false;
            }
        };
    }

    public String[] getRegistrationIDs(AuthConfigProvider provider) {
        ArrayList al = new ArrayList();
        if (provider == null) {
            al.addAll(this.idToDescriptionMap.keySet());
        } else {
            List list = (List)this.providerToIDListMap.get(provider);
            if (list != null) {
                al.addAll(list);
            }
        }
        String[] sarr = new String[al.size()];
        al.toArray(sarr);
        return sarr;
    }

    public String registerConfigProvider(String className, Map properties, String layer, String appContext, String description) throws AuthException, SecurityException {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("className is null or zero length");
        }
        AuthConfigProvider acp = null;
        try {
            Class<?> provClass = SecurityActions.getContextClassLoader().loadClass(className);
            Constructor<?> ctr = provClass.getConstructor(Map.class);
            acp = (AuthConfigProvider)ctr.newInstance(properties);
        }
        catch (Exception e) {
            log.error((Object)("Cannot register provider:" + className + ":"), (Throwable)e);
            throw new AuthException("Cannot register Provider " + className + ":reason=" + e);
        }
        return this.registerConfigProvider(acp, layer, appContext, description);
    }

    public String registerConfigProvider(AuthConfigProvider provider, String layer, String appContext, String description) {
        RegistrationListener listener;
        if (provider == null) {
            throw new IllegalArgumentException("provider is null");
        }
        StringBuilder key = new StringBuilder();
        key.append(layer == null ? "NULL" : layer.toUpperCase());
        key.append("_");
        key.append(appContext == null ? "NULL" : appContext.toUpperCase());
        String keystr = key.toString();
        this.keyProviderMap.put(keystr, provider);
        UUID guid = UUID.randomUUID();
        String providerID = guid.toString();
        this.idKeyMap.put(providerID, keystr);
        ArrayList<String> list = (ArrayList<String>)this.providerToIDListMap.get(provider);
        if (list == null) {
            list = new ArrayList<String>();
        }
        list.add(providerID);
        this.providerToIDListMap.put(provider, list);
        if (description != null) {
            this.idToDescriptionMap.put(providerID, description);
        }
        if ((listener = (RegistrationListener)this.keyListenerMap.get(keystr)) != null) {
            listener.notify(layer, appContext);
        }
        return providerID;
    }

    public boolean removeRegistration(String registrationID) {
        if (registrationID == null) {
            throw new IllegalArgumentException("registrationID is null");
        }
        String key = (String)this.idKeyMap.get(registrationID);
        if (key != null) {
            RegistrationListener listener = (RegistrationListener)this.keyListenerMap.get(key);
            AuthConfigFactory.RegistrationContext rc = this.getRegistrationContext(registrationID);
            this.keyProviderMap.remove(key);
            if (listener != null) {
                listener.notify(rc.getMessageLayer(), rc.getAppContext());
            }
            return true;
        }
        return false;
    }
}

