/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.web;

import com.sun.xacml.Indenter;
import com.sun.xacml.attr.AnyURIAttribute;
import com.sun.xacml.attr.AttributeValue;
import com.sun.xacml.attr.StringAttribute;
import com.sun.xacml.attr.TimeAttribute;
import com.sun.xacml.ctx.Attribute;
import com.sun.xacml.ctx.RequestCtx;
import com.sun.xacml.ctx.Subject;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.Principal;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebXACMLUtil {
    private static Logger log = Logger.getLogger(WebXACMLUtil.class);
    private boolean trace = log.isTraceEnabled();

    public RequestCtx createXACMLRequest(HttpServletRequest request, RoleGroup callerRoles) throws Exception {
        if (request == null) {
            throw new IllegalArgumentException("Http Request is null");
        }
        if (callerRoles == null) {
            throw new IllegalArgumentException("roles is null");
        }
        String httpMethod = request.getMethod();
        String action = "GET".equals(httpMethod) ? "read" : "write";
        String actionURIBase = "urn:oasis:names:tc:xacml:2.0:request-param:attribute:";
        RequestCtx requestCtx = null;
        Principal principal = request.getUserPrincipal();
        String username = principal.getName();
        URI subjectAttrUri = new URI("urn:oasis:names:tc:xacml:1.0:subject:subject-id");
        Attribute subjectAttr = new Attribute(subjectAttrUri, null, null, (AttributeValue)new StringAttribute(username));
        HashSet<Attribute> subjectAttrSet = new HashSet<Attribute>();
        subjectAttrSet.add(subjectAttr);
        subjectAttrSet.addAll(this.getXACMLRoleSet(callerRoles));
        HashSet<Subject> subjectSet = new HashSet<Subject>();
        subjectSet.add(new Subject(subjectAttrSet));
        URI resourceUri = new URI("urn:oasis:names:tc:xacml:1.0:resource:resource-id");
        Attribute resourceAttr = new Attribute(resourceUri, null, null, (AttributeValue)new AnyURIAttribute(new URI(request.getRequestURI())));
        HashSet<Attribute> resourceSet = new HashSet<Attribute>();
        resourceSet.add(resourceAttr);
        HashSet<Attribute> actionSet = new HashSet<Attribute>();
        actionSet.add(new Attribute(new URI("urn:oasis:names:tc:xacml:1.0:action:action-id"), null, null, (AttributeValue)new StringAttribute(action)));
        Enumeration enumer = request.getParameterNames();
        while (enumer.hasMoreElements()) {
            String paramName = (String)enumer.nextElement();
            String paramValue = request.getParameter(paramName);
            URI actionUri = new URI(actionURIBase + paramName);
            Attribute actionAttr = new Attribute(actionUri, null, null, (AttributeValue)new StringAttribute(paramValue));
            actionSet.add(actionAttr);
        }
        HashSet<Attribute> environSet = new HashSet<Attribute>();
        URI currentTimeUri = new URI("urn:oasis:names:tc:xacml:1.0:environment:current-time");
        Attribute currentTimeAttr = new Attribute(currentTimeUri, null, null, (AttributeValue)new TimeAttribute());
        environSet.add(currentTimeAttr);
        requestCtx = new RequestCtx(subjectSet, resourceSet, actionSet, environSet);
        if (this.trace) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            requestCtx.encode((OutputStream)baos, new Indenter());
            log.trace((Object)("XACML Request:" + baos.toString()));
            baos.close();
        }
        return requestCtx;
    }

    private Set<Attribute> getXACMLRoleSet(RoleGroup roles) throws Exception {
        URI roleURI = new URI("urn:oasis:names:tc:xacml:2.0:subject:role");
        HashSet<Attribute> roleset = new HashSet<Attribute>();
        List croles = roles.getRoles();
        for (Role r : croles) {
            Attribute roleAttr = new Attribute(roleURI, null, null, (AttributeValue)new StringAttribute(r.getRoleName()));
            roleset.add(roleAttr);
        }
        return roleset;
    }
}

