/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import org.jboss.logging.Logger;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AbstractJACCModuleDelegate;
import org.jboss.security.authorization.resources.EJBResource;
import org.jboss.security.identity.Role;
import org.jboss.security.identity.RoleGroup;

public class EJBJACCPolicyModuleDelegate
extends AbstractJACCModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private String methodInterface = null;
    private CodeSource ejbCS = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;

    public EJBJACCPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource, Subject callerSubject, RoleGroup role) {
        if (!(resource instanceof EJBResource)) {
            throw new IllegalArgumentException("resource is not an EJBResource");
        }
        EJBResource ejbResource = (EJBResource)resource;
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        this.policyRegistration = (PolicyRegistration)map.get("policyRegistration");
        this.ejbCS = ejbResource.getCodeSource();
        this.ejbMethod = ejbResource.getEjbMethod();
        this.ejbName = ejbResource.getEjbName();
        this.methodInterface = ejbResource.getEjbMethodInterface();
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef(callerSubject, role);
        }
        return this.process(callerSubject, (Role)role);
    }

    private int process(Subject callerSubject, Role role) {
        EJBMethodPermission methodPerm = new EJBMethodPermission(this.ejbName, this.methodInterface, this.ejbMethod);
        boolean policyDecision = this.checkWithPolicy((Permission)methodPerm, callerSubject, role);
        if (!policyDecision) {
            String msg = "Denied: " + methodPerm + ", caller=" + callerSubject;
            if (this.trace) {
                log.trace((Object)("EJB Jacc Delegate:" + msg));
            }
        }
        return policyDecision ? 1 : -1;
    }

    private int checkRoleRef(Subject callerSubject, RoleGroup callerRoles) {
        EJBRoleRefPermission ejbRoleRefPerm = new EJBRoleRefPermission(this.ejbName, this.roleName);
        boolean policyDecision = this.checkWithPolicy((Permission)ejbRoleRefPerm, callerSubject, (Role)callerRoles);
        if (!policyDecision) {
            String msg = "Denied: " + ejbRoleRefPerm + ", caller=" + callerSubject;
            if (this.trace) {
                log.trace((Object)("EJB Jacc Delegate:" + msg));
            }
        }
        return policyDecision ? 1 : -1;
    }

    private boolean checkWithPolicy(Permission ejbPerm, Subject subject, Role role) {
        Principal[] principals = this.getPrincipals(subject, role);
        ProtectionDomain pd = new ProtectionDomain(this.ejbCS, null, null, principals);
        return Policy.getPolicy().implies(pd, ejbPerm);
    }
}

