/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.acl;

import org.jboss.security.acl.ACLEntry;
import org.jboss.security.acl.ACLPermission;
import org.jboss.security.acl.BitMaskPermission;
import org.jboss.security.identity.Identity;

public class ACLEntryImpl
implements ACLEntry {
    private final BitMaskPermission permission;
    private final Identity identity;

    public ACLEntryImpl(BitMaskPermission permission, Identity identity) {
        this.permission = permission;
        this.identity = identity;
    }

    public Identity getIdentity() {
        return this.identity;
    }

    public ACLPermission getPermission() {
        return this.permission;
    }

    public boolean checkPermission(ACLPermission permission) {
        if (!(permission instanceof BitMaskPermission)) {
            return false;
        }
        BitMaskPermission bitmaskPermission = (BitMaskPermission)permission;
        if (bitmaskPermission.getMaskValue() == 0) {
            return true;
        }
        return (this.permission.getMaskValue() & bitmaskPermission.getMaskValue()) != 0;
    }
}

