/*
  * JBoss, Home of Professional Open Source
  * Copyright 2007, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.mapping.providers.principal;

import java.security.Principal;
import java.util.Map;

import javax.security.auth.x500.X500Principal;
import java.security.cert.X509Certificate;

import org.jboss.logging.Logger;
import org.jboss.security.auth.certs.SubjectDNMapping;
import org.jboss.security.mapping.MappingProvider;
import org.jboss.security.mapping.MappingResult;

//$Id$

/**
 *  A X500 Principal Mapper from a X509 Certificate
 *  that considers SubjectDN of the Client certificate
 *  
 *  @see org.jboss.security.auth.certs.SubjectDNMapping
 *  @author Anil.Saldhana@redhat.com
 *  @since  Oct 5, 2007 
 *  @version $Revision$
 */
public class SubjectDNMapper implements MappingProvider<Principal>
{ 
   private static final Logger log = Logger.getLogger(SubjectDNMapper.class);
   private Map options = null;
   private MappingResult<Principal> result;

   public void init(Map opt)
   {
      this.options = opt; 
   }

   public void setMappingResult(MappingResult res)
   { 
      result = res;
   }
   
   public void performMapping(Map contextMap, Principal principal)
   {
      if(contextMap == null)
         throw new IllegalArgumentException("ContextMap is null");
      
      X509Certificate[] certs = (X509Certificate[]) contextMap.get("X509");
      if(certs != null)
      {
        SubjectDNMapping sdn = new SubjectDNMapping();
        principal = sdn.toPrinicipal(certs);
        if(log.isTraceEnabled())
           log.trace("Mapped to Principal:"+principal);
      } 

      result.setMappedObject(principal);
   } 
}
