/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.authorization.modules.ejb;

import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.security.AnybodyPrincipal;
import org.jboss.security.AuthorizationManager;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SecurityRoleRef;
import org.jboss.security.SimplePrincipal;
import org.jboss.security.authorization.PolicyRegistration;
import org.jboss.security.authorization.Resource;
import org.jboss.security.authorization.modules.AuthorizationModuleDelegate;

public class EJBPolicyModuleDelegate
extends AuthorizationModuleDelegate {
    private String ejbName = null;
    private Method ejbMethod = null;
    private Principal ejbPrincipal = null;
    private Set methodRoles = null;
    private String methodInterface = null;
    private RunAsIdentity callerRunAsIdentity = null;
    private String roleName = null;
    private Boolean roleRefCheck = Boolean.FALSE;
    private Set securityRoleReferences = null;

    public EJBPolicyModuleDelegate() {
        log = Logger.getLogger(this.getClass());
        this.trace = log.isTraceEnabled();
    }

    public int authorize(Resource resource) {
        Map map = resource.getMap();
        if (map == null) {
            throw new IllegalStateException("Map from the Resource is null");
        }
        if (map.size() == 0) {
            throw new IllegalStateException("Map from the Resource is size zero");
        }
        AuthorizationManager am = (AuthorizationManager)map.get("authorizationManager");
        if (am == null) {
            throw new IllegalStateException("Authorization Manager is null");
        }
        if (am instanceof PolicyRegistration) {
            this.policyRegistration = (PolicyRegistration)am;
        }
        this.ejbMethod = (Method)map.get("ejb.method");
        this.ejbName = (String)map.get("ejb.name");
        this.ejbPrincipal = (Principal)map.get("ejb.principal");
        this.methodInterface = (String)map.get("ejb.methodInterface");
        this.methodRoles = (Set)map.get("ejb.methodRoles");
        this.callerRunAsIdentity = (RunAsIdentity)map.get("runAsIdentity");
        this.roleName = (String)map.get("roleName");
        this.roleRefCheck = (Boolean)map.get("roleRefPermissionCheck");
        this.securityRoleReferences = (Set)map.get("securityRoleReferences");
        if (this.roleRefCheck == Boolean.TRUE) {
            return this.checkRoleRef();
        }
        return this.process();
    }

    private int process() {
        String msg;
        String method;
        boolean allowed = true;
        if (this.methodRoles == null) {
            method = this.ejbMethod.getName();
            msg = "No method permissions assigned to method=" + method + ", interface=" + this.methodInterface;
            if (this.trace) {
                log.trace((Object)("Exception:" + msg));
            }
            allowed = false;
        } else if (this.trace) {
            log.trace((Object)("method=" + this.ejbMethod + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles));
        }
        if (!this.methodRoles.contains(AnybodyPrincipal.ANYBODY_PRINCIPAL)) {
            if (this.callerRunAsIdentity == null) {
                AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
                if (!am.doesUserHaveRole(this.ejbPrincipal, this.methodRoles)) {
                    Set userRoles = am.getUserRoles(this.ejbPrincipal);
                    String method2 = this.ejbMethod.getName();
                    String msg2 = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method2 + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", principalRoles=" + userRoles;
                    if (this.trace) {
                        log.trace((Object)("Exception:" + msg2));
                    }
                    allowed = false;
                }
            } else if (!this.callerRunAsIdentity.doesUserHaveRole(this.methodRoles)) {
                method = this.ejbMethod.getName();
                msg = "Insufficient method permissions, principal=" + this.ejbPrincipal + ", ejbName=" + this.ejbName + ", method=" + method + ", interface=" + this.methodInterface + ", requiredRoles=" + this.methodRoles + ", runAsRoles=" + this.callerRunAsIdentity.getRunAsRoles();
                if (this.trace) {
                    log.trace((Object)("Exception:" + msg));
                }
                allowed = false;
            }
        }
        return allowed ? 1 : -1;
    }

    private int checkRoleRef() {
        AuthorizationManager am = (AuthorizationManager)this.policyRegistration;
        if (this.ejbPrincipal == null && this.callerRunAsIdentity == null) {
            if (this.trace) {
                log.trace((Object)"ejbPrincipal = null,callerRunAsIdentity = null => DENY");
            }
            return -1;
        }
        boolean matchFound = false;
        for (SecurityRoleRef meta : this.securityRoleReferences) {
            if (!meta.getName().equals(this.roleName)) continue;
            this.roleName = meta.getLink();
            matchFound = true;
            break;
        }
        if (!matchFound) {
            log.trace((Object)("no match found for security role " + this.roleName + " in the deployment descriptor for ejb " + this.ejbName));
        }
        HashSet<Principal> set = new HashSet<Principal>();
        set.add(new SimplePrincipal(this.roleName));
        boolean allowed = false;
        allowed = this.callerRunAsIdentity == null ? am.doesUserHaveRole(this.ejbPrincipal, set) : this.callerRunAsIdentity.doesUserHaveRole(set);
        return allowed ? 1 : -1;
    }
}

