/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.security.xacml.bridge.JBossPolicyFinder;
import org.jboss.security.xacml.interfaces.ContextMapOp;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.Policy;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.util.XACMLPolicyUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossXACMLPolicy
implements XACMLPolicy,
ContextMapOp {
    private JBossPolicyFinder finder = new JBossPolicyFinder();
    private List<XACMLPolicy> enclosingPolicies = new ArrayList<XACMLPolicy>();
    private int policyType = 1;
    private Map<String, Object> map = new HashMap<String, Object>();

    public JBossXACMLPolicy(URL url, int type) throws Exception {
        this(url.openStream(), type);
    }

    public JBossXACMLPolicy(InputStream is, JBossPolicyFinder theFinder) throws Exception {
        this.finder = theFinder;
        AbstractPolicy policy = null;
        XACMLPolicyUtil xpu = new XACMLPolicyUtil();
        policy = xpu.create(is, this.finder);
        this.policyType = policy instanceof PolicySet ? 0 : 1;
        this.map.put("underlying_policy", policy);
    }

    public JBossXACMLPolicy(InputStream is, int type) throws Exception {
        PolicySet policy = null;
        XACMLPolicyUtil xpu = new XACMLPolicyUtil();
        this.policyType = type;
        if (type == 0) {
            policy = xpu.createPolicySet(is, (PolicyFinder)this.finder);
            this.map.put("policy_finder", (Object)this.finder);
        } else if (type == 1) {
            policy = xpu.createPolicy(is);
        } else {
            throw new RuntimeException("Unknown type");
        }
        this.map.put("underlying_policy", policy);
    }

    public JBossXACMLPolicy(InputStream is, int type, JBossPolicyFinder theFinder) throws Exception {
        Policy policy = null;
        XACMLPolicyUtil xpu = new XACMLPolicyUtil();
        this.policyType = type;
        if (type == 0) {
            if (theFinder == null) {
                throw new IllegalArgumentException("policy finder is null");
            }
            this.finder = theFinder;
            policy = xpu.createPolicySet(is, (PolicyFinder)theFinder);
            this.map.put("policy_finder", (Object)theFinder);
        } else if (type == 1) {
            policy = xpu.createPolicy(is);
        } else {
            throw new RuntimeException("Unknown type");
        }
        this.map.put("underlying_policy", policy);
    }

    @Override
    public int getType() {
        return this.policyType;
    }

    @Override
    public void setEnclosingPolicies(List<XACMLPolicy> policies) {
        this.enclosingPolicies.addAll(policies);
    }

    @Override
    public List<XACMLPolicy> getEnclosingPolicies() {
        return this.enclosingPolicies;
    }

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }
}

