/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.bridge;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.security.xacml.sunxacml.AbstractPolicy;
import org.jboss.security.xacml.sunxacml.EvaluationCtx;
import org.jboss.security.xacml.sunxacml.MatchResult;
import org.jboss.security.xacml.sunxacml.PolicyMetaData;
import org.jboss.security.xacml.sunxacml.PolicySet;
import org.jboss.security.xacml.sunxacml.VersionConstraints;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PolicySetFinderModule
extends PolicyFinderModule {
    private PolicySet policySet;
    private final Map<URI, AbstractPolicy> policies = new HashMap<URI, AbstractPolicy>();
    protected PolicyFinder policyFinder = null;

    public PolicySetFinderModule() {
    }

    public PolicySetFinderModule(PolicySet policySet) {
        this.policySet = policySet;
    }

    public PolicySetFinderModule(PolicySet policySet, List<AbstractPolicy> policies) {
        this.policySet = policySet;
        if (policies != null) {
            for (AbstractPolicy p : policies) {
                this.policies.put(p.getId(), p);
            }
        }
    }

    public void init(PolicyFinder finder) {
        this.policyFinder = finder;
    }

    public PolicyFinderResult findPolicy(EvaluationCtx context) {
        PolicySet selectedPolicy = null;
        MatchResult match = this.policySet.match(context);
        int result = match.getResult();
        if (result == 2) {
            return new PolicyFinderResult(match.getStatus());
        }
        if (result == 0) {
            if (selectedPolicy != null) {
                ArrayList<String> code = new ArrayList<String>();
                code.add("urn:oasis:names:tc:xacml:1.0:status:processing-error");
                Status status = new Status(code, "too many applicable top-level policies");
                return new PolicyFinderResult(status);
            }
            selectedPolicy = this.policySet;
        }
        return new PolicyFinderResult(selectedPolicy);
    }

    public PolicyFinderResult findPolicy(URI idReference, int type, VersionConstraints constraints, PolicyMetaData parentMetaData) {
        AbstractPolicy p;
        AbstractPolicy abstractPolicy = p = idReference != null ? this.policies.get(idReference) : null;
        if (p != null) {
            return new PolicyFinderResult(p);
        }
        return new PolicyFinderResult();
    }

    public boolean isRequestSupported() {
        return true;
    }

    public boolean isIdReferenceSupported() {
        return true;
    }

    public void set(PolicySet ps, List<AbstractPolicy> policies) {
        this.policySet = ps;
        this.policies.clear();
        if (policies != null) {
            for (AbstractPolicy p : policies) {
                this.policies.put(p.getId(), p);
            }
        }
    }
}

