/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.XMLStreamReader;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.jboss.security.xacml.bridge.JBossPolicyFinder;
import org.jboss.security.xacml.core.SecurityActions;
import org.jboss.security.xacml.factories.PolicyFactory;
import org.jboss.security.xacml.factories.RequestResponseContextFactory;
import org.jboss.security.xacml.interfaces.AbstractLocator;
import org.jboss.security.xacml.interfaces.PolicyDecisionPoint;
import org.jboss.security.xacml.interfaces.PolicyLocator;
import org.jboss.security.xacml.interfaces.RequestContext;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.jboss.security.xacml.interfaces.XACMLPolicy;
import org.jboss.security.xacml.jaxb.LocatorType;
import org.jboss.security.xacml.jaxb.LocatorsType;
import org.jboss.security.xacml.jaxb.Option;
import org.jboss.security.xacml.jaxb.PDP;
import org.jboss.security.xacml.jaxb.PoliciesType;
import org.jboss.security.xacml.jaxb.PolicySetType;
import org.jboss.security.xacml.jaxb.PolicyType;
import org.jboss.security.xacml.locators.AttributeLocator;
import org.jboss.security.xacml.locators.ResourceLocator;
import org.jboss.security.xacml.sunxacml.PDPConfig;
import org.jboss.security.xacml.sunxacml.ctx.RequestCtx;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinder;
import org.jboss.security.xacml.sunxacml.finder.AttributeFinderModule;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinder;
import org.jboss.security.xacml.sunxacml.finder.PolicyFinderModule;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinder;
import org.jboss.security.xacml.sunxacml.finder.ResourceFinderModule;
import org.jboss.security.xacml.sunxacml.finder.impl.CurrentEnvModule;
import org.jboss.security.xacml.sunxacml.finder.impl.SelectorModule;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossPDP
implements PolicyDecisionPoint {
    private Unmarshaller unmarshaller = null;
    private Set<AttributeFinderModule> attributeLocators = new HashSet<AttributeFinderModule>();
    private Set<PolicyLocator> policyLocators = new HashSet<PolicyLocator>();
    private Set<ResourceLocator> resourceLocators = new HashSet<ResourceLocator>();
    private Set<XACMLPolicy> policies = new HashSet<XACMLPolicy>();
    private JBossPolicyFinder policyFinder = new JBossPolicyFinder();
    private org.jboss.security.xacml.sunxacml.PDP policyDecisionPoint = null;
    private Lock lock = new ReentrantLock();

    public JBossPDP() {
        this.createValidatingUnMarshaller();
    }

    public JBossPDP(InputStream configFile) {
        this();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(InputSource configFile) {
        this();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(Node configFile) {
        this();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(XMLStreamReader configFile) {
        this();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFile);
            this.bootstrap((PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(URL configFileURL) {
        this();
        try {
            JAXBElement jxb = (JAXBElement)this.unmarshaller.unmarshal(configFileURL.openStream());
            this.bootstrap((PDP)jxb.getValue());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public JBossPDP(JAXBElement<?> config) {
        Object object = config.getValue();
        if (!(object instanceof PDP)) {
            throw new IllegalArgumentException("Not PDP configuration");
        }
        try {
            this.bootstrap((PDP)object);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setLocators(Set<PolicyLocator> locators) {
        this.policyLocators = locators;
    }

    @Override
    public void setPolicies(Set<XACMLPolicy> policies) {
        this.policies = policies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ResponseContext evaluate(RequestContext request) {
        RequestCtx req = (RequestCtx)request.get("request_ctx");
        if (req == null) {
            throw new IllegalStateException("Request Context does not contain a request");
        }
        if (this.policyDecisionPoint == null) {
            this.bootstrapPDP();
        }
        ResponseCtx resp = null;
        this.lock.lock();
        try {
            resp = this.policyDecisionPoint.evaluate(req);
        }
        finally {
            this.lock.unlock();
        }
        ResponseContext response = RequestResponseContextFactory.createResponseContext();
        response.set("response_ctx", resp);
        return response;
    }

    private void bootstrap(PDP pdp) throws Exception {
        int len;
        boolean justLocators = false;
        PoliciesType policiesType = pdp.getPolicies();
        if (policiesType != null) {
            List<PolicySetType> pset = policiesType.getPolicySet();
            this.addPolicySets(pset, true);
            List<XACMLPolicy> policyList = this.addPolicies(policiesType.getPolicy());
            this.policies.addAll(policyList);
        } else {
            justLocators = true;
        }
        LocatorsType locatorsType = pdp.getLocators();
        if (policiesType == null && locatorsType == null) {
            throw new IllegalStateException("Configuration should have either policies or locators");
        }
        List<LocatorType> locs = locatorsType.getLocator();
        for (LocatorType lt : locs) {
            List<Option> options = lt.getOption();
            AbstractLocator locator = (AbstractLocator)this.loadClass(lt.getName()).newInstance();
            locator.setOptions(options);
            if (locator instanceof PolicyLocator) {
                PolicyLocator pl = (PolicyLocator)locator;
                if (!justLocators) {
                    pl.setPolicies(this.policies);
                }
                this.policyLocators.add(pl);
                continue;
            }
            if (locator instanceof AttributeLocator) {
                AttributeLocator attribLocator = (AttributeLocator)locator;
                this.attributeLocators.add(attribLocator);
                continue;
            }
            if (!(locator instanceof ResourceLocator)) continue;
            ResourceLocator resourceLocator = (ResourceLocator)locator;
            this.resourceLocators.add(resourceLocator);
        }
        if (justLocators && (len = this.policyLocators.size()) > 0) {
            for (PolicyLocator pl : this.policyLocators) {
                pl.set("policy_finder", this.policyFinder);
            }
        }
        this.bootstrapPDP();
    }

    private List<AttributeFinderModule> createAttributeFinderModules() {
        ArrayList<AttributeFinderModule> attributeModules = new ArrayList<AttributeFinderModule>();
        attributeModules.add((AttributeFinderModule)new CurrentEnvModule());
        attributeModules.add((AttributeFinderModule)new SelectorModule());
        attributeModules.addAll(this.attributeLocators);
        return attributeModules;
    }

    private Set<PolicyFinderModule> createPolicyFinderModules() {
        HashSet<PolicyFinderModule> policyModules = new HashSet<PolicyFinderModule>();
        for (PolicyLocator locator : this.policyLocators) {
            List finderModulesList = (List)locator.get("policy_finder_module");
            if (finderModulesList == null) {
                throw new IllegalStateException("Locator " + locator.getClass().getName() + " has no policy finder modules");
            }
            policyModules.addAll(finderModulesList);
        }
        return policyModules;
    }

    private List<ResourceFinderModule> createResourceFinderModules() {
        ArrayList<ResourceFinderModule> resourceFinderModules = new ArrayList<ResourceFinderModule>();
        for (ResourceLocator resourceLocator : this.resourceLocators) {
            resourceFinderModules.add(resourceLocator);
        }
        return resourceFinderModules;
    }

    private void bootstrapPDP() {
        AttributeFinder attributeFinder = new AttributeFinder();
        attributeFinder.setModules(this.createAttributeFinderModules());
        this.policyFinder.setModules(this.createPolicyFinderModules());
        ResourceFinder resourceFinder = new ResourceFinder();
        resourceFinder.setModules(this.createResourceFinderModules());
        PDPConfig pdpConfig = new PDPConfig(attributeFinder, (PolicyFinder)this.policyFinder, resourceFinder);
        this.policyDecisionPoint = new org.jboss.security.xacml.sunxacml.PDP(pdpConfig);
    }

    private List<XACMLPolicy> addPolicySets(List<PolicySetType> policySets, boolean topLevel) throws Exception {
        ArrayList<XACMLPolicy> list = new ArrayList<XACMLPolicy>();
        for (PolicySetType pst : policySets) {
            String loc = pst.getLocation();
            XACMLPolicy policySet = PolicyFactory.createPolicySet(this.getInputStream(loc), this.policyFinder);
            list.add(policySet);
            List<XACMLPolicy> policyList = this.addPolicies(pst.getPolicy());
            policySet.setEnclosingPolicies(policyList);
            List<PolicySetType> pset = pst.getPolicySet();
            if (pset != null) {
                policySet.getEnclosingPolicies().addAll(this.addPolicySets(pset, false));
            }
            if (!topLevel) continue;
            this.policies.add(policySet);
        }
        return list;
    }

    private List<XACMLPolicy> addPolicies(List<PolicyType> policies) throws Exception {
        ArrayList<XACMLPolicy> policyList = new ArrayList<XACMLPolicy>();
        for (PolicyType pt : policies) {
            policyList.add(PolicyFactory.createPolicy(this.getInputStream(pt.getLocation())));
        }
        return policyList;
    }

    private void createValidatingUnMarshaller() {
        try {
            JAXBContext jc = JAXBContext.newInstance((String)"org.jboss.security.xacml.jaxb");
            this.unmarshaller = jc.createUnmarshaller();
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            URL schemaURL = tcl.getResource("schema/jbossxacml-2.0.xsd");
            if (schemaURL == null) {
                throw new IllegalStateException("Schema URL is null:schema/jbossxacml-2.0.xsd");
            }
            SchemaFactory scFact = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = scFact.newSchema(schemaURL);
            this.unmarshaller.setSchema(schema);
        }
        catch (Exception jxb) {
            throw new RuntimeException(jxb);
        }
    }

    private InputStream getInputStream(String loc) {
        InputStream is = null;
        try {
            URL url = new URL(loc);
            is = url.openStream();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (is == null) {
            ClassLoader tcl = SecurityActions.getContextClassLoader();
            is = tcl.getResourceAsStream(loc);
        }
        if (is == null) {
            throw new RuntimeException("Null Inputstream for " + loc);
        }
        return is;
    }

    private Class<?> loadClass(String fqn) throws Exception {
        ClassLoader tcl = SecurityActions.getContextClassLoader();
        return tcl.loadClass(fqn);
    }
}

