/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core.ext;

import java.net.URI;
import java.net.URISyntaxException;
import org.jboss.security.xacml.core.ext.SingleValueAttribute;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.SunxacmlUtil;
import org.jboss.security.xacml.sunxacml.UnknownIdentifierException;
import org.jboss.security.xacml.sunxacml.attr.AttributeFactory;
import org.jboss.security.xacml.sunxacml.attr.AttributeProxy;
import org.jboss.security.xacml.sunxacml.attr.AttributeValue;
import org.jboss.security.xacml.sunxacml.attr.StringAttribute;
import org.w3c.dom.Node;

public class SingleValueAttributeProxy
implements AttributeProxy {
    private URI type;

    public SingleValueAttributeProxy(String type) {
        try {
            this.type = new URI(type);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public SingleValueAttributeProxy(URI type) {
        this.type = type;
    }

    public AttributeValue getInstance(Node root) throws Exception {
        if (SunxacmlUtil.getNodeName((Node)root).equals("AttributeValue")) {
            try {
                Node child = root.getFirstChild();
                if (child == null) {
                    return new StringAttribute("");
                }
                short nodetype = child.getNodeType();
                if (nodetype == 3 || nodetype == 4 || nodetype == 8) {
                    return new StringAttribute(child.getNodeValue());
                }
                return AttributeFactory.getInstance().createValue(child, this.type);
            }
            catch (UnknownIdentifierException uie) {
                throw new ParsingException("Unknown AttributeId", (Throwable)uie);
            }
        }
        return null;
    }

    public AttributeValue getInstance(String value) throws Exception {
        return new SingleValueAttribute(this.type, value);
    }
}

