/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.xacml.core;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.DocumentBuilderFactory;
import org.jboss.security.xacml.core.model.context.ObjectFactory;
import org.jboss.security.xacml.core.model.context.ResultType;
import org.jboss.security.xacml.core.model.context.StatusCodeType;
import org.jboss.security.xacml.core.model.context.StatusType;
import org.jboss.security.xacml.core.model.policy.EffectType;
import org.jboss.security.xacml.core.model.policy.ObligationType;
import org.jboss.security.xacml.core.model.policy.ObligationsType;
import org.jboss.security.xacml.interfaces.ResponseContext;
import org.jboss.security.xacml.sunxacml.Indenter;
import org.jboss.security.xacml.sunxacml.Obligation;
import org.jboss.security.xacml.sunxacml.ParsingException;
import org.jboss.security.xacml.sunxacml.ctx.ResponseCtx;
import org.jboss.security.xacml.sunxacml.ctx.Result;
import org.jboss.security.xacml.sunxacml.ctx.Status;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossResponseContext
implements ResponseContext {
    private int decision = 1;
    private Map<String, Object> map = new HashMap<String, Object>();
    private Node documentElement = null;

    @Override
    public <T> T get(String key) {
        return (T)this.map.get(key);
    }

    @Override
    public <T> void set(String key, T obj) {
        this.map.put(key, obj);
    }

    @Override
    public int getDecision() {
        ResponseCtx response = (ResponseCtx)this.map.get("response_ctx");
        if (response != null) {
            Set results = response.getResults();
            Result res = (Result)results.iterator().next();
            this.decision = res.getDecision();
        }
        return this.decision;
    }

    @Override
    public ResultType getResult() {
        ObjectFactory objectFactory = new ObjectFactory();
        ResultType resultType = objectFactory.createResultType();
        ResponseCtx response = (ResponseCtx)this.map.get("response_ctx");
        if (response != null) {
            Result result = (Result)response.getResults().iterator().next();
            resultType.setResourceId(result.getResource());
            Status status = result.getStatus();
            StatusType statusType = objectFactory.createStatusType();
            StatusCodeType statusCodeType = objectFactory.createStatusCodeType();
            statusCodeType.setValue(status.getMessage());
            statusType.setStatusCode(statusCodeType);
            Set obligationsSet = result.getObligations();
            if (obligationsSet != null) {
                for (Obligation obl : obligationsSet) {
                    ObligationType obType = new ObligationType();
                    obType.setObligationId(obl.getId().toASCIIString());
                    obType.setFulfillOn(EffectType.fromValue(Result.DECISIONS[obl.getFulfillOn()]));
                    ObligationsType obligationsType = new ObligationsType();
                    obligationsType.getObligation().add(obType);
                    resultType.setObligations(obligationsType);
                }
            }
        }
        return resultType;
    }

    @Override
    public Node getDocumentElement() {
        return this.documentElement;
    }

    @Override
    public void marshall(OutputStream os) throws IOException {
        ResponseCtx storedResponse = (ResponseCtx)this.get("response_ctx");
        if (storedResponse != null) {
            storedResponse.encode(os, new Indenter(0), "urn:oasis:names:tc:xacml:2.0:context:schema:os");
        }
    }

    @Override
    public void readResponse(InputStream is) throws Exception {
        this.readResponse(this.getResponse(is));
    }

    @Override
    public void readResponse(Node node) throws IOException {
        if (node == null) {
            throw new IllegalArgumentException("node is null");
        }
        this.documentElement = node;
        try {
            ResponseCtx responseCtx = ResponseCtx.getInstance((Node)node);
            this.set("response_ctx", responseCtx);
        }
        catch (ParsingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Element asElement(Document root) {
        throw new RuntimeException("SECURITY-177");
    }

    private Node getResponse(InputStream is) throws Exception {
        String contextSchema = "urn:oasis:names:tc:xacml:2.0:context:schema:os";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setIgnoringComments(true);
        Document doc = factory.newDocumentBuilder().parse(is);
        NodeList nodes = doc.getElementsByTagNameNS(contextSchema, "Response");
        if (nodes.getLength() == 0) {
            nodes = doc.getElementsByTagName("Response");
        }
        return nodes.item(0);
    }
}

