/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.vault;

import org.jboss.security.vault.SecurityActions;
import org.jboss.security.vault.SecurityVault;
import org.jboss.security.vault.SecurityVaultException;

public class SecurityVaultFactory {
    private static String defaultVault = "org.jboss.security.plugins.vault.PicketBoxSecurityVault";
    private static SecurityVault vault = null;

    public static SecurityVault get() throws SecurityVaultException {
        return SecurityVaultFactory.get(defaultVault);
    }

    public static SecurityVault get(String fqn) throws SecurityVaultException {
        if (fqn == null) {
            return SecurityVaultFactory.get();
        }
        if (vault == null) {
            Class<?> vaultClass = SecurityActions.loadClass(SecurityVaultFactory.class, fqn);
            if (vaultClass == null) {
                throw new SecurityVaultException("Unable to load vault class");
            }
            try {
                vault = (SecurityVault)vaultClass.newInstance();
            }
            catch (Exception e) {
                throw new SecurityVaultException("Unable to instantiate vault class");
            }
        }
        return vault;
    }
}

