/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;

public class SecurityContextAssociation {
    private static boolean SERVER = true;
    private static SecurityContext securityContext = null;
    public static final String SECURITYCONTEXT_THREADLOCAL = "org.jboss.security.context.ThreadLocal";
    private static final String SECURITYASSOCIATION_THREADLOCAL = "org.jboss.security.SecurityAssociation.ThreadLocal";
    private static ThreadLocal<SecurityContext> securityContextLocal;

    public static boolean isClient() {
        return !SERVER;
    }

    public static void setClient() {
        SERVER = false;
    }

    public static void setSecurityContext(SecurityContext sc) {
        if (!SERVER) {
            securityContext = sc;
        } else {
            securityContextLocal.set(sc);
        }
    }

    public static SecurityContext getSecurityContext() {
        if (!SERVER) {
            return securityContext;
        }
        return securityContextLocal.get();
    }

    public static void clearSecurityContext() {
        if (!SERVER) {
            securityContext = null;
        } else {
            securityContextLocal.set(null);
        }
    }

    private static String getSystemProperty(final String propertyName, final String defaultString) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultString);
            }
        });
    }

    static {
        String saflag = SecurityContextAssociation.getSystemProperty(SECURITYASSOCIATION_THREADLOCAL, "false");
        String scflag = SecurityContextAssociation.getSystemProperty(SECURITYCONTEXT_THREADLOCAL, "false");
        boolean useThreadLocal = Boolean.valueOf(saflag) != false || Boolean.valueOf(scflag) != false;
        securityContextLocal = useThreadLocal ? new ThreadLocal() : new InheritableThreadLocal<SecurityContext>();
    }
}

