/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.security.SecurityContext;

public class SecurityContextAssociation {
    public static final String SECURITYCONTEXT_THREADLOCAL = "org.jboss.security.context.ThreadLocal";
    private static final String SECURITYASSOCIATION_THREADLOCAL = "org.jboss.security.SecurityAssociation.ThreadLocal";
    private static ThreadLocal<SecurityContext> securityContextLocal;

    public static void setSecurityContext(SecurityContext sc) {
        securityContextLocal.set(sc);
    }

    public static SecurityContext getSecurityContext() {
        return securityContextLocal.get();
    }

    public static void clearSecurityContext() {
        securityContextLocal.set(null);
    }

    private static String getSystemProperty(final String propertyName, final String defaultString) {
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return System.getProperty(propertyName, defaultString);
            }
        });
    }

    static {
        String saflag = SecurityContextAssociation.getSystemProperty(SECURITYASSOCIATION_THREADLOCAL, "false");
        String scflag = SecurityContextAssociation.getSystemProperty(SECURITYCONTEXT_THREADLOCAL, "false");
        boolean useThreadLocal = Boolean.valueOf(saflag) != false || Boolean.valueOf(scflag) != false;
        securityContextLocal = useThreadLocal ? new ThreadLocal() : new InheritableThreadLocal<SecurityContext>();
    }
}

