/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.jboss.security.identity.Identity;
import org.jboss.security.identity.RoleGroup;
import org.jboss.security.identity.extensions.CredentialIdentityFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SubjectInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Subject authenticatedSubject;
    private RoleGroup roles;
    private Set<Identity> identities;

    SubjectInfo(Principal principal, Object credential, Subject subject) {
        this.addIdentity((Identity)CredentialIdentityFactory.createIdentity((Principal)principal, (Object)credential));
        this.authenticatedSubject = subject;
    }

    SubjectInfo(Identity identity, Subject theSubject) {
        this.addIdentity(identity);
        this.authenticatedSubject = theSubject;
    }

    public Subject getAuthenticatedSubject() {
        return this.authenticatedSubject;
    }

    public void setAuthenticatedSubject(Subject authenticatedSubject) {
        this.authenticatedSubject = authenticatedSubject;
    }

    public RoleGroup getRoles() {
        return this.roles;
    }

    public void setRoles(RoleGroup roles) {
        this.roles = roles;
    }

    public void addIdentity(Identity id) {
        if (this.identities == null) {
            this.identities = new HashSet<Identity>();
        }
        this.identities.add(id);
    }

    public <T> T getIdentity(Class<T> clazz) {
        if (this.identities != null) {
            for (Identity id : this.identities) {
                if (!clazz.isAssignableFrom(id.getClass())) continue;
                return (T)id;
            }
        }
        return null;
    }

    public Set<Identity> getIdentities() {
        return this.identities;
    }

    public void setIdentities(Set<Identity> ids) {
        if (this.identities == null) {
            this.identities = new HashSet<Identity>();
        }
        this.identities.addAll(ids);
    }
}

