/*
  * JBoss, Home of Professional Open Source
  * Copyright 2006, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security;

import java.io.Serializable;
import java.security.Principal;

import javax.security.auth.Subject;

//$Id$

/**
 *  Holds information - principal, credential and subject
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Dec 26, 2006 
 *  @version $Revision$
 */
public class SubjectInfo implements Serializable
{ 
   private static final long serialVersionUID = 1L;
   private Principal authenticationPrincipal;
   private Object authenticationCredential;
   private Subject authenticatedSubject;
   
   SubjectInfo(Principal principal, Object credential,Subject subject)
   {
      this.authenticationPrincipal = principal;
      this.authenticationCredential = credential;
      this.authenticatedSubject = subject;
   }
   
   public Principal getAuthenticationPrincipal()
   {
      return authenticationPrincipal;
   }
   
   public void setAuthenticationPrincipal(Principal authenticationPrincipal)
   {
      this.authenticationPrincipal = authenticationPrincipal;
   }
   
   public Object getAuthenticationCredential()
   {
      return authenticationCredential;
   }
   
   public void setAuthenticationCredential(Object authenticationCredential)
   {
      this.authenticationCredential = authenticationCredential;
   }
   
   public Subject getAuthenticatedSubject()
   {
      return authenticatedSubject;
   }
   
   public void setAuthenticatedSubject(Subject authenticatedSubject)
   {
      this.authenticatedSubject = authenticatedSubject;
   } 
} 
