/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego.encoding;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosKey;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.cipher.Decoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenDecoder;

public class TokenParser {
    private String crealm;
    private String cname;

    public void parseToken(byte[] data, Subject subject) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        byte[] b = this.getAP_REQ(bais);
        bais.close();
        bais = new ByteArrayInputStream(b);
        b = this.getTicket(bais);
        bais.close();
        bais = new ByteArrayInputStream(b);
        b = this.getEncryptedData(bais);
        bais.close();
        bais = new ByteArrayInputStream(b);
        this.handleEncryptedData(bais, b.length, subject);
        bais.close();
    }

    public byte[] getValueAt(InputStream is, byte type) throws Exception {
        byte tag;
        byte[] bytes = null;
        do {
            tag = (byte)is.read();
            int sequenceLength = NegTokenDecoder.readLength(is);
            bytes = new byte[sequenceLength];
            is.read(bytes);
            if (is.available() != 0) continue;
            is = new ByteArrayInputStream(bytes);
        } while (!this.isContextSpecific(tag, type));
        return bytes;
    }

    public boolean isContextSpecific(byte tag, byte cntxtTag) {
        return (tag & 0x1F) == cntxtTag;
    }

    public byte[] getAP_REQ(InputStream is) throws Exception {
        is.read();
        NegTokenDecoder.readLength(is);
        byte[] bytes = this.getValueAt(is, (byte)14);
        return bytes;
    }

    public byte[] getTicket(InputStream is) throws Exception {
        byte[] bytes = this.getValueAt(is, (byte)3);
        return bytes;
    }

    public byte[] getEncryptedData(InputStream is) throws Exception {
        byte[] bytes = this.getValueAt(is, (byte)3);
        return bytes;
    }

    public void handleEncryptedData(InputStream is, int size, Subject subject) throws Exception {
        is.mark(size);
        byte[] bytes = this.getValueAt(is, (byte)0);
        bytes = Arrays.copyOfRange(bytes, 2, 3);
        BigInteger bi = new BigInteger(bytes);
        int eType = bi.intValue();
        KerberosKey key = this.getKrbKey(subject, eType);
        is.reset();
        bytes = this.getValueAt(is, (byte)2);
        byte[] cipher = Arrays.copyOfRange(bytes, 3, bytes.length);
        byte[] ticketBytes = this.decrypt(key, cipher);
        byte[] temp = this.reset(ticketBytes);
        ByteArrayInputStream bais = new ByteArrayInputStream(temp);
        bais.read();
        int length = NegTokenDecoder.readLength(bais);
        temp = new byte[length];
        bais.read(temp);
        bais.close();
        bais = new ByteArrayInputStream(temp);
        byte[] realm = this.getValueAt(bais, (byte)2);
        bais.close();
        realm = Arrays.copyOfRange(realm, 2, realm.length);
        this.crealm = new String(realm);
        bais = new ByteArrayInputStream(temp);
        byte[] principalName = this.getValueAt(bais, (byte)3);
        bais.close();
        bais = new ByteArrayInputStream(principalName);
        byte[] names = this.getValueAt(bais, (byte)1);
        bais.close();
        names = Arrays.copyOfRange(names, 2, names.length);
        bais = new ByteArrayInputStream(names);
        String[] cnames = this.getNames(bais);
        bais.close();
        StringBuffer buffer = new StringBuffer(cnames[0]);
        for (int i = 1; i < cnames.length; ++i) {
            buffer.append("/");
            buffer.append(cnames[i]);
        }
        this.cname = buffer.toString();
    }

    public String[] getNames(InputStream is) throws Exception {
        ArrayList<String> principals = new ArrayList<String>();
        do {
            is.read();
            int length = NegTokenDecoder.readLength(is);
            byte[] name = new byte[length];
            is.read(name);
            principals.add(new String(name));
        } while (is.available() > 0);
        String[] names = new String[principals.size()];
        names = principals.toArray(names);
        return names;
    }

    public KerberosKey getKrbKey(Subject sub, int keyType) {
        Set<Object> creds = sub.getPrivateCredentials(Object.class);
        for (Object cred : creds) {
            KerberosKey key;
            if (!(cred instanceof KerberosKey) || (key = (KerberosKey)cred).getKeyType() != keyType) continue;
            return (KerberosKey)cred;
        }
        return null;
    }

    public byte[] decrypt(KerberosKey key, byte[] cipher) throws NegotiationException {
        Decoder decoder = Decoder.getInstace(key.getKeyType());
        byte[] plain = decoder.decrypt(cipher, key.getEncoded(), 2);
        return decoder.decryptedData(plain);
    }

    public byte[] reset(byte[] data) {
        byte[] bytes = null;
        if ((data[1] & 0xFF) < 128) {
            bytes = new byte[data[1] + 2];
            System.arraycopy(data, 0, bytes, 0, data[1] + 2);
        } else if ((data[1] & 0xFF) > 128) {
            int len = data[1] & 0x7F;
            int result = 0;
            for (int i = 0; i < len; ++i) {
                result |= (data[i + 2] & 0xFF) << 8 * (len - i - 1);
            }
            bytes = new byte[result + len + 2];
            System.arraycopy(data, 0, bytes, 0, result + len + 2);
        }
        return bytes;
    }

    public String getPrincipalName() {
        return this.cname + "@" + this.crealm;
    }
}

