/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.ntlm.encoding;

import java.io.IOException;
import java.io.InputStream;
import org.jboss.security.negotiation.ntlm.encoding.DecoderData;
import org.jboss.security.negotiation.ntlm.encoding.NTLMField;

public class FieldDecoder {
    public static final byte MSB_MASK = -128;

    static NTLMField readFieldLengths(InputStream is, DecoderData data) throws IOException {
        NTLMField field = new NTLMField();
        byte[] len = new byte[2];
        byte[] maxLen = new byte[2];
        byte[] offset = new byte[4];
        is.read(len);
        is.read(maxLen);
        is.read(offset);
        data.read += 8;
        field.setLength(FieldDecoder.convertToUnsignedInt(len));
        field.setMaxLength(FieldDecoder.convertToUnsignedInt(maxLen));
        field.setOffset(FieldDecoder.convertToUnsignedInt(offset));
        return field;
    }

    static int convertToUnsignedInt(byte[] bytes) {
        int total = 0;
        for (int i = 0; i < bytes.length; ++i) {
            byte current = bytes[i];
            boolean msbSet = (byte)(current & 0xFFFFFF80) == -128;
            int value = current & 0x7F;
            if (msbSet) {
                value += 128;
            }
            if (i > 0) {
                value *= (int)Math.pow(2.0, 8 * i);
            }
            total += value;
        }
        return total;
    }
}

