/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.spnego;

import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.acl.Group;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.Oid;
import org.jboss.security.SimpleGroup;
import org.jboss.security.auth.spi.AbstractServerLoginModule;
import org.jboss.security.negotiation.MessageTrace;
import org.jboss.security.negotiation.spnego.SPNEGOContext;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInitDecoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTargDecoder;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTargEncoder;
import org.jboss.util.Base64;

public class SPNEGOLoginModule
extends AbstractServerLoginModule {
    private static final Oid kerberos;
    private String serverSecurityDomain;
    private LoginContext serverLoginContext = null;
    private Principal identity = null;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.serverSecurityDomain = (String)options.get("serverSecurityDomain");
        this.log.debug((Object)("serverSecurityDomain=" + this.serverSecurityDomain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean login() throws LoginException {
        if (super.login()) {
            this.log.debug((Object)"super.login()==true");
            return true;
        }
        this.loginOk = false;
        SPNEGOContext spnegoContext = SPNEGOContext.getCurrentSPNEGOContext();
        try {
            Subject server = this.getServerSubject();
            AcceptSecContext action = new AcceptSecContext(spnegoContext);
            Object result = Subject.doAs(server, action);
            this.log.trace((Object)("Result - " + result));
            if (result instanceof Boolean) {
                if (Boolean.TRUE.equals(result)) {
                    this.loginOk = true;
                    if (this.getUseFirstPass()) {
                        String userName = this.identity.getName();
                        this.log.debug((Object)("Storing username '" + userName + "' and empty password"));
                        this.sharedState.put("javax.security.auth.login.name", this.identity);
                        this.sharedState.put("javax.security.auth.login.password", "");
                    }
                }
            } else if (result instanceof Exception) {
                Exception e = (Exception)result;
                this.log.error((Object)"Unable to authenticate", (Throwable)e);
                throw new LoginException("Unable to authenticate - " + e.getMessage());
            }
        }
        finally {
            if (this.serverLoginContext != null) {
                this.serverLoginContext.logout();
            }
        }
        this.log.trace((Object)("super.loginOk " + this.loginOk));
        if (this.loginOk) {
            return true;
        }
        throw new LoginException("Continuation Required.");
    }

    protected Principal getIdentity() {
        return this.identity;
    }

    protected Group[] getRoleSets() throws LoginException {
        SimpleGroup roles = new SimpleGroup("Roles");
        SimpleGroup callerPrincipal = new SimpleGroup("CallerPrincipal");
        Group[] groups = new Group[]{roles, callerPrincipal};
        callerPrincipal.addMember(this.identity);
        return groups;
    }

    protected Subject getServerSubject() throws LoginException {
        LoginContext lc = new LoginContext(this.serverSecurityDomain);
        lc.login();
        this.serverLoginContext = lc;
        Subject serverSubject = this.serverLoginContext.getSubject();
        this.log.debug((Object)("Subject = " + serverSubject));
        this.log.debug((Object)("Logged in '" + this.serverSecurityDomain + "' LoginContext"));
        return serverSubject;
    }

    static {
        try {
            kerberos = new Oid("1.2.840.113554.1.2.2");
        }
        catch (GSSException e) {
            throw new RuntimeException("Unable to initialise Oid", e);
        }
    }

    private class AcceptSecContext
    implements PrivilegedAction {
        private final SPNEGOContext spnegoContext;

        public AcceptSecContext(SPNEGOContext spnegoContext) {
            this.spnegoContext = spnegoContext;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Object run() {
            try {
                byte[] gssToken;
                block13: {
                    String requestHeader = this.spnegoContext.getRequestHeader();
                    byte[] reqToken = Base64.decode((String)requestHeader);
                    MessageTrace.logRequestBase64(this.spnegoContext.getRequestHeader());
                    MessageTrace.logRequestHex(reqToken);
                    gssToken = null;
                    if (reqToken[0] == 96) {
                        NegTokenInit negTokenInit = NegTokenInitDecoder.decode(reqToken);
                        List<Oid> mechList = negTokenInit.getMechTypes();
                        if (mechList.get(0).equals(kerberos)) {
                            gssToken = negTokenInit.getMechToken();
                            break block13;
                        } else {
                            boolean kerberosSupported = false;
                            Iterator<Oid> it = mechList.iterator();
                            while (it.hasNext() && !kerberosSupported) {
                                kerberosSupported = it.next().equals(kerberos);
                            }
                            NegTokenTarg negTokenTarg = new NegTokenTarg();
                            if (kerberosSupported) {
                                negTokenTarg.setNegResult(NegTokenTarg.ACCEPT_INCOMPLETE);
                                negTokenTarg.setSupportedMech(kerberos);
                            } else {
                                negTokenTarg.setNegResult(NegTokenTarg.REJECTED);
                            }
                            byte[] respSpnego = NegTokenTargEncoder.encode(negTokenTarg);
                            String respEncoded = Base64.encodeBytes((byte[])respSpnego);
                            MessageTrace.logResponseBase64(respEncoded);
                            MessageTrace.logResponseHex(respSpnego);
                            this.spnegoContext.setResponseHeader(respEncoded);
                            return Boolean.FALSE;
                        }
                    }
                    if (reqToken[0] != -95) {
                        throw new LoginException("Unsupported negotiation mechanism.");
                    }
                    NegTokenTarg negTokenTarg = NegTokenTargDecoder.decode(reqToken);
                    gssToken = negTokenTarg.getResponseToken();
                }
                GSSContext gssContext = this.spnegoContext.getGssContext();
                if (gssContext == null) {
                    SPNEGOLoginModule.this.log.debug((Object)"Creating new GSSContext.");
                    GSSManager manager = GSSManager.getInstance();
                    gssContext = manager.createContext((GSSCredential)null);
                    this.spnegoContext.setGssContext(gssContext);
                }
                if (gssContext.isEstablished()) {
                    SPNEGOLoginModule.this.log.warn((Object)"Authentication was performed despite already being authenticated!");
                    SPNEGOLoginModule.this.identity = new KerberosPrincipal(((Object)gssContext.getSrcName()).toString());
                    SPNEGOLoginModule.this.log.debug((Object)("context.getCredDelegState() = " + gssContext.getCredDelegState()));
                    SPNEGOLoginModule.this.log.debug((Object)("context.getMutualAuthState() = " + gssContext.getMutualAuthState()));
                    SPNEGOLoginModule.this.log.debug((Object)("context.getSrcName() = " + ((Object)gssContext.getSrcName()).toString()));
                    this.spnegoContext.setAuthenticated(true);
                    return Boolean.TRUE;
                }
                byte[] respToken = gssContext.acceptSecContext(gssToken, 0, gssToken.length);
                if (respToken != null) {
                    NegTokenTarg negTokenTarg = new NegTokenTarg();
                    negTokenTarg.setResponseToken(respToken);
                    byte[] respSpnego = NegTokenTargEncoder.encode(negTokenTarg);
                    String respEncoded = Base64.encodeBytes((byte[])respSpnego);
                    MessageTrace.logResponseBase64(respEncoded);
                    MessageTrace.logResponseHex(respSpnego);
                    this.spnegoContext.setResponseHeader(respEncoded);
                }
                if (!gssContext.isEstablished()) {
                    return Boolean.FALSE;
                }
                SPNEGOLoginModule.this.identity = new KerberosPrincipal(((Object)gssContext.getSrcName()).toString());
                SPNEGOLoginModule.this.log.debug((Object)("context.getCredDelegState() = " + gssContext.getCredDelegState()));
                SPNEGOLoginModule.this.log.debug((Object)("context.getMutualAuthState() = " + gssContext.getMutualAuthState()));
                SPNEGOLoginModule.this.log.debug((Object)("context.getSrcName() = " + ((Object)gssContext.getSrcName()).toString()));
                this.spnegoContext.setAuthenticated(true);
                return Boolean.TRUE;
            }
            catch (Exception e) {
                return e;
            }
        }
    }
}

