/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.toolkit;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;

public class SecurityDomainTestServlet
extends HttpServlet {
    private static final long serialVersionUID = -3129778766905747055L;
    private static final Logger log = Logger.getLogger(SecurityDomainTestServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String securityDomain = req.getParameter("securityDomain");
        PrintWriter writer = resp.getWriter();
        writer.println("<html>");
        writer.println("  <head>");
        writer.println("    <title>Negotiation Toolkit</title>");
        writer.println("  </head>");
        writer.println("  <body>");
        writer.println("    <h1>Negotiation Toolkit</h1>");
        writer.println("    <h2>Security Domain Test</h2>");
        if (securityDomain == null) {
            this.displayForm(writer);
        } else {
            this.testDomain(securityDomain, writer);
        }
        writer.println("  </body>");
        writer.println("</html>");
        writer.flush();
    }

    private void displayForm(PrintWriter writer) {
        writer.println("    <p>Please enter the name of the security-domain used for the server to authenticate itself.</p>");
        writer.println("    <p>");
        writer.println("      <form method='get'>");
        writer.println("        Security Domain <input type='text' name='securityDomain' value='host'><br>");
        writer.println("        <br><input type='submit' value='Test'>");
        writer.println("      </form>");
        writer.println("    </p>");
    }

    private void testDomain(String securityDomain, PrintWriter writer) {
        writer.print("<p>Testing security-domain '");
        writer.print(securityDomain);
        writer.println("'</p>");
        try {
            String currentLine;
            LoginContext context = new LoginContext(securityDomain);
            log.debug((Object)("Obtained LoginContext for '" + securityDomain + "' security-domain."));
            context.login();
            writer.println("<h4>Authenticated</h4>");
            Subject subject = context.getSubject();
            ByteArrayInputStream bais = new ByteArrayInputStream(String.valueOf(subject).getBytes());
            InputStreamReader isr = new InputStreamReader(bais);
            BufferedReader br = new BufferedReader(isr);
            writer.println("<code>");
            while ((currentLine = br.readLine()) != null) {
                writer.print(currentLine);
                writer.println("<br>");
            }
            writer.println("</code>");
            context.logout();
            log.debug((Object)"logged out.");
        }
        catch (Exception e) {
            writer.println("<h5>Failed!</h5>");
            writer.print("<p>");
            writer.print(e.getClass().getName());
            writer.print(" - ");
            writer.print(e.getMessage());
            writer.println("</p>");
            log.error((Object)"testDomain Failed", (Throwable)e);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }
}

