/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.toolkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.ntlm.encoding.NTLMField;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateMessage;
import org.picketbox.commons.cipher.Base64;

public class NTLMNegotiationServlet
extends HttpServlet {
    private static final long serialVersionUID = -3291448937864587130L;
    private static final Logger log = Logger.getLogger(NTLMNegotiationServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String authHeader = req.getHeader("Authorization");
        NegotiationMessage message = (NegotiationMessage)req.getAttribute("message");
        if (message == null && authHeader == null) {
            log.info((Object)"No Authorization Header, sending 401");
            resp.setHeader("WWW-Authenticate", "NTLM");
            resp.sendError(401);
            return;
        }
        log.info((Object)"Authorization header received - decoding token.");
        Object response = null;
        if (message == null) {
            String requestHeader = "";
            if (authHeader.startsWith("Negotiate ")) {
                requestHeader = authHeader.substring(10);
            } else if (authHeader.startsWith("NTLM ")) {
                requestHeader = authHeader.substring(5);
            }
            if (requestHeader.length() > 0) {
                byte[] reqToken = Base64.decode((String)requestHeader);
                ByteArrayInputStream bais = new ByteArrayInputStream(reqToken);
                MessageFactory mf = null;
                try {
                    mf = MessageFactory.newInstance();
                }
                catch (NegotiationException e) {
                    throw new ServletException("Unable to create MessageFactory", (Throwable)e);
                }
                response = mf.accepts((InputStream)bais) ? ((message = mf.createMessage((InputStream)bais)) instanceof NegotiateMessage ? message : "<p><b>Unsuported negotiation token.</b></p>") : "<p><b>Unsuported negotiation token.</b></p>";
            }
        } else {
            log.info((Object)"Using existing message.");
            response = message;
        }
        PrintWriter writer = resp.getWriter();
        writer.println("<html>");
        writer.println("  <head>");
        writer.println("    <title>Negotiation Toolkit</title>");
        writer.println("  </head>");
        writer.println("  <body>");
        writer.println("    <h1>Negotiation Toolkit</h1>");
        writer.println("    <h2>NTLM Negotiation</h2>");
        writer.println("    <p>WWW-Authenticate - ");
        writer.println(authHeader);
        writer.println("    </p>");
        try {
            this.writeHeaderDetail(response, writer);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException("Unable to writeHeaderDetail", (Throwable)e);
        }
        writer.println("  </body>");
        writer.println("</html>");
        writer.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void writeHeaderDetail(Object response, PrintWriter writer) throws IOException {
        if (response instanceof String) {
            writer.println((String)response);
        } else if (response instanceof NegotiateMessage) {
            NegotiateMessage message = (NegotiateMessage)response;
            writer.println("<h3>NTLM - Negotiate_Message</h3>");
            writer.write("<h4><font color='red'>Warning, this is NTLM, only SPNEGO is supported!</font></h4>");
            writer.write("<b>Negotiate Flags</b> - ");
            writer.write(String.valueOf(message.getNegotiateFlags()));
            writer.write("<br>");
            this.writeNTLMField("Domain Name", message.getDomainName(), message.getDomainNameFields(), writer);
            this.writeNTLMField("Workstation Name", message.getWorkstationName(), message.getWorkstationFields(), writer);
            if (message.getVersion() != null && message.getVersion().length > 0) {
                writer.write("<b>Version </b> - ");
                writer.write(new String(message.getVersion()));
                writer.write("<br>");
            }
        }
    }

    private void writeNTLMField(String name, String value, NTLMField field, PrintWriter writer) {
        writer.write("<b>");
        writer.write(name);
        writer.write("</b> = ");
        writer.write(String.valueOf(value));
        writer.write(" - <i>");
        writer.write(String.valueOf(field));
        writer.write("</i><br>");
    }
}

