/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation.toolkit;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.ietf.jgss.Oid;
import org.jboss.logging.Logger;
import org.jboss.security.negotiation.MessageFactory;
import org.jboss.security.negotiation.NegotiationException;
import org.jboss.security.negotiation.NegotiationMessage;
import org.jboss.security.negotiation.OidNameUtil;
import org.jboss.security.negotiation.common.DebugHelper;
import org.jboss.security.negotiation.ntlm.encoding.NegotiateMessage;
import org.jboss.security.negotiation.spnego.KerberosMessage;
import org.jboss.security.negotiation.spnego.encoding.NegTokenInit;
import org.jboss.security.negotiation.spnego.encoding.NegTokenTarg;
import org.picketbox.commons.cipher.Base64;

public class BasicNegotiationServlet
extends HttpServlet {
    private static final long serialVersionUID = 7269693410644316525L;
    private static final Logger log = Logger.getLogger(BasicNegotiationServlet.class);

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            log.info((Object)"No Authorization Header, sending 401");
            resp.setHeader("WWW-Authenticate", "Negotiate");
            resp.sendError(401);
            return;
        }
        log.info((Object)"Authorization header received - decoding token.");
        String response = null;
        String requestHeader = "";
        if (authHeader.startsWith("Negotiate ")) {
            requestHeader = authHeader.substring(10);
        } else if (authHeader.startsWith("NTLM ")) {
            requestHeader = authHeader.substring(5);
        }
        if (requestHeader.length() > 0) {
            byte[] reqToken = Base64.decode((String)requestHeader);
            ByteArrayInputStream bais = new ByteArrayInputStream(reqToken);
            MessageFactory mf = null;
            try {
                mf = MessageFactory.newInstance();
            }
            catch (NegotiationException e) {
                throw new ServletException("Unable to create MessageFactory", (Throwable)e);
            }
            if (mf.accepts((InputStream)bais)) {
                NegotiationMessage message = mf.createMessage((InputStream)bais);
                if (message instanceof NegotiateMessage) {
                    req.setAttribute("message", (Object)message);
                    RequestDispatcher dispatcher = this.getServletContext().getRequestDispatcher("/NTLMNegotiation");
                    dispatcher.forward((ServletRequest)req, (ServletResponse)resp);
                    return;
                }
                if (message instanceof NegTokenInit || message instanceof KerberosMessage) {
                    response = message;
                } else if (message instanceof NegTokenTarg) {
                    response = "<p><b>Unexpected NegTokenTarg, first token should be NegTokenInit!</b></p>";
                }
            } else {
                response = "<p><b>Unsuported negotiation token.</b></p>";
            }
        } else {
            response = "<p><b>Header WWW-Authenticate does not beging with 'Negotiate' or 'NTLM'!</b></p>";
        }
        PrintWriter writer = resp.getWriter();
        writer.println("<html>");
        writer.println("  <head>");
        writer.println("    <title>Negotiation Toolkit</title>");
        writer.println("  </head>");
        writer.println("  <body>");
        writer.println("    <h1>Negotiation Toolkit</h1>");
        writer.println("    <h2>Basic Negotiation</h2>");
        writer.println("    <p>WWW-Authenticate - ");
        writer.println(authHeader);
        writer.println("    </p>");
        this.writeHeaderDetail((Object)response, writer);
        writer.println("  </body>");
        writer.println("</html>");
        writer.flush();
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.doGet(req, resp);
    }

    private void writeHeaderDetail(Object response, PrintWriter writer) throws IOException {
        if (response instanceof String) {
            writer.println((String)response);
        } else if (response instanceof NegTokenInit) {
            NegTokenInit negTokenInit = (NegTokenInit)response;
            writer.println("<h3>NegTokenInit</h3>");
            writer.print("<b>Message Oid - </b>");
            writer.print(OidNameUtil.getName((Oid)negTokenInit.getMessageOid()));
            writer.println("<br>");
            List mechTypes = negTokenInit.getMechTypes();
            writer.print("<b>Mech Types -</b>");
            for (Oid current : mechTypes) {
                writer.print(" {");
                writer.print(OidNameUtil.getName((Oid)current));
                writer.print("}");
            }
            writer.println("<br>");
            writer.print("<b>Req Flags -</b>");
            byte[] reqFlags = negTokenInit.getReqFlags();
            if (reqFlags != null && reqFlags.length > 0) {
                writer.print(DebugHelper.convertToHex((byte[])reqFlags));
            }
            writer.println("<br>");
            writer.print("<b>Mech Token -</b>");
            byte[] mechToken = negTokenInit.getMechToken();
            if (mechToken != null && mechToken.length > 0) {
                writer.print(new String(Base64.encodeBytes((byte[])mechToken)));
            }
            writer.println("<br>");
            writer.print("<b>Mech List Mic -</b>");
            byte[] mechTokenMic = negTokenInit.getMechListMIC();
            if (mechTokenMic != null && mechTokenMic.length > 0) {
                writer.print(new String(Base64.encodeBytes((byte[])mechTokenMic)));
            }
            writer.println("<br>");
        } else if (response instanceof KerberosMessage) {
            writer.println("<h3>KerberosV5</h3>");
            writer.print("<b>Message Oid - </b>");
            writer.print(OidNameUtil.getName((Oid)((KerberosMessage)response).getMessageOid()));
            writer.println("<br>");
        }
    }
}

