/*
  * JBoss, Home of Professional Open Source
  * Copyright 2005, JBoss Inc., and individual contributors as indicated
  * by the @authors tag. See the copyright.txt in the distribution for a
  * full listing of individual contributors.
  *
  * This is free software; you can redistribute it and/or modify it
  * under the terms of the GNU Lesser General Public License as
  * published by the Free Software Foundation; either version 2.1 of
  * the License, or (at your option) any later version.
  *
  * This software is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
  * Lesser General Public License for more details.
  *
  * You should have received a copy of the GNU Lesser General Public
  * License along with this software; if not, write to the Free
  * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
  * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
  */
package org.jboss.security.authorization;

import java.io.InputStream;
import java.net.URL;
import java.util.Map;

//$Id: PolicyRegistration.java 66941 2007-11-09 20:23:39Z anil.saldhana@jboss.com $

/**
 *  Interface to register policies
 *  @author <a href="mailto:Anil.Saldhana@jboss.org">Anil Saldhana</a>
 *  @since  Jun 18, 2006 
 *  @version $Revision: 66941 $
 */
public interface PolicyRegistration
{
   /**
    * Register a policy given the location and a context id
    * @param contextID
    * @param location location of the Policy File
    */
   void registerPolicy(String contextID, URL location);
   
   /**
    * 
    * Register a policy given a xml based stream and a context id
    * 
    * @param contextID
    * @param stream InputStream that is an XML stream
    */
   void registerPolicy(String contextID, InputStream stream);
   
   /**
    * Unregister a policy  
    * @param contextID Context ID
    */
   void deRegisterPolicy(String contextID); 
   
   /**
    * Obtain the registered policy for the context id
    * @param contextID Context ID
    * @param contextMap A map that can be used by the implementation
    *           to determine the policy choice (typically null)
    */
   Object getPolicy(String contextID, Map<String,Object> contextMap);
}
