/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.examples.webclient;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Produces;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.social.MultiServicesManager;
import org.jboss.seam.social.SocialNetworkServicesHub;
import org.jboss.seam.social.event.SocialEvent;
import org.jboss.seam.social.event.StatusUpdated;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.seam.social.oauth.OAuthToken;
import org.jboss.solder.logging.Logger;

@Named
@SessionScoped
public class SocialClient
implements Serializable {
    private static final long serialVersionUID = 3723552335163650582L;
    private String Status;
    @Inject
    private Logger log;
    @Inject
    private MultiServicesManager manager;

    public String getStatus() {
        return this.Status;
    }

    public void setStatus(String status) {
        this.Status = status;
    }

    public MultiServicesManager getManager() {
        return this.manager;
    }

    public void setManager(MultiServicesManager manager) {
        this.manager = manager;
    }

    public OAuthSession getCurrentSession() {
        return this.manager.getCurrentSession();
    }

    public void setCurrentSession(OAuthSession currentSession) {
        this.manager.setCurrentSession(currentSession);
    }

    public Map<String, OAuthSession> getSessionsMap() {
        return Maps.uniqueIndex((Iterable)this.getSessions(), (Function)new /* Unavailable Anonymous Inner Class!! */);
    }

    @Produces
    @Named
    public OAuthService getCurrentService() {
        return this.manager.getCurrentService();
    }

    @Produces
    @Named
    public SocialNetworkServicesHub getCurrentHub() {
        return this.manager.getCurrentServiceHub();
    }

    public List<OAuthSession> getSessions() {
        return Lists.newArrayList((Iterable)this.manager.getActiveSessions());
    }

    public OAuthToken getAccessToken() {
        return this.getCurrentSession().getAccessToken();
    }

    public void connectCurrentService() {
        this.manager.connectCurrentService();
    }

    public String getCurrentSessionName() {
        return this.manager.getCurrentSession() == null ? "" : this.manager.getCurrentSession().toString();
    }

    public void setCurrentSessionName(String cursrvHdlStr) {
        this.setCurrentSession((OAuthSession)this.getSessionsMap().get(cursrvHdlStr));
    }

    public void redirectToAuthorizationURL(String url) throws IOException {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        externalContext.redirect(url);
    }

    public String getTimeLineUrl() {
        if (this.getCurrentSession() != null && this.getCurrentSession().isConnected()) {
            return "/WEB-INF/fragments/" + this.getManager().getCurrentService().getType().toLowerCase() + ".xhtml";
        }
        return "";
    }

    public void serviceInit(String servType) throws IOException {
        this.redirectToAuthorizationURL(this.manager.initNewSession(servType));
    }

    protected void statusUpdateObserver(@Observes @Any StatusUpdated statusUpdate) {
        if (statusUpdate.getStatus().equals((Object)SocialEvent.Status.SUCCESS)) {
            this.log.debugf("Status update with : %s ", (Object)statusUpdate.getMessage());
            this.setStatus("");
        }
    }

    public void resetConnection() {
        this.manager.destroyCurrentSession();
    }
}

