/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.examples.tasks.resource;

import java.util.List;
import javax.ejb.Stateless;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.jboss.seam.rest.examples.tasks.entity.Category;
import org.jboss.seam.rest.examples.tasks.entity.Task;

@Stateless
public class CollectionBean {
    @PersistenceContext
    private EntityManager em;

    public List<Category> getCategories(int start, int limit) {
        Query query = this.em.createNamedQuery("categories");
        this.applyPaginationParameters(query, start, limit);
        return query.getResultList();
    }

    public List<Task> getTasks(int start, int limit, String status, String categoryName) {
        Query query = null;
        query = categoryName == null ? this.em.createNamedQuery("tasks") : this.em.createNamedQuery("tasksByCategory").setParameter("category", (Object)categoryName);
        query = this.applyResolutionParameter(query, status);
        this.applyPaginationParameters(query, start, limit);
        return query.getResultList();
    }

    protected Query applyResolutionParameter(Query query, String status) {
        if ("resolved".equals(status)) {
            return query.setParameter("r1", (Object)true).setParameter("r2", (Object)true);
        }
        if ("unresolved".equals(status)) {
            return query.setParameter("r1", (Object)false).setParameter("r2", (Object)false);
        }
        return query.setParameter("r1", (Object)true).setParameter("r2", (Object)false);
    }

    protected void applyPaginationParameters(Query query, int start, int limit) {
        query.setFirstResult(start);
        if (limit != 0) {
            query.setMaxResults(limit);
        }
    }
}

