/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate.test;

import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.hibernate.Session;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.HotelNameProducer;
import org.jboss.seam.persistence.test.util.ManagedHibernateSessionProvider;
import org.jboss.seam.transaction.DefaultTransaction;
import org.jboss.seam.transaction.SeamTransaction;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class ManagedHibernateSessionELTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    Session session;

    public static Class<?>[] getTestClasses() {
        return new Class[]{ManagedHibernateSessionELTestBase.class, Hotel.class, ManagedHibernateSessionProvider.class, HotelNameProducer.class, HelloService.class};
    }

    @Test
    public void testELInInquery() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.transaction.begin();
        Hotel h = new Hotel("Hilton", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.commit();
        this.transaction.begin();
        h = new Hotel("Other Hotel", "Real St ", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.commit();
        this.transaction.begin();
        Hotel hilton = (Hotel)this.session.createQuery("select h from Hotel h where h.name=#{hotelName}").uniqueResult();
        Assert.assertTrue((boolean)hilton.getName().equals("Hilton"));
        Assert.assertTrue((boolean)hilton.getAddress().equals("Fake St"));
        this.transaction.commit();
    }
}

