/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.test.util;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactResolver {
    private final String classPathSeparatorRegex;
    private final char fileSeparator;
    private final String groupId;
    private final String artifactId;
    private final String classPath;

    public static File resolve(String groupId, String artifactId) {
        if (groupId == null) {
            throw new IllegalArgumentException("groupId cannot be null");
        }
        if (artifactId == null) {
            throw new IllegalArgumentException("artifactId cannot be null");
        }
        String path = new MavenArtifactResolver(groupId.trim(), artifactId.trim(), System.getProperty("java.class.path"), File.pathSeparatorChar, File.separatorChar).resolve();
        if (path == null) {
            throw new IllegalArgumentException("Cannot locate artifact for " + groupId + ":" + artifactId);
        }
        return new File(path);
    }

    public static File resolve(String qualifiedArtifactId) {
        String[] segments = qualifiedArtifactId.split(":");
        if (segments.length == 2) {
            return MavenArtifactResolver.resolve(segments[0], segments[1]);
        }
        throw new IllegalArgumentException("Unable to parse " + qualifiedArtifactId + " as a groupId:artifactId");
    }

    MavenArtifactResolver(String groupId, String artifactId, String classPath, char pathSeparator, char fileSeparator) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.classPath = classPath;
        this.classPathSeparatorRegex = "[^" + pathSeparator + "]*";
        this.fileSeparator = fileSeparator;
    }

    String resolve() {
        Matcher matches = this.createFullyQualifiedMatcher();
        if (!matches.find() && !(matches = this.createUnqualifiedMatcher()).find()) {
            matches = this.createTargetClassesMatcher();
            if (!matches.find()) {
                return null;
            }
            String fileName = this.scanForArtifact(matches);
            if (fileName == null) {
                return null;
            }
            return fileName;
        }
        return matches.group(0);
    }

    private String scanForArtifact(Matcher targetClassesMatcher) {
        ArrayList<String> paths = new ArrayList<String>();
        do {
            String path;
            File target;
            if (!(target = new File((path = targetClassesMatcher.group()).substring(0, path.length() - 8))).exists()) continue;
            if (!target.isDirectory()) {
                throw new IllegalStateException("Found ${project.dir}/target/ but it is not a directory!");
            }
            for (File file : target.listFiles()) {
                paths.add(file.getPath());
            }
        } while (targetClassesMatcher.find());
        return this.scanForArtifact(paths);
    }

    String scanForArtifact(List<String> paths) {
        Pattern pattern = Pattern.compile(this.artifactId + "-[\\d+\\.]+(?:[\\-\\.]\\p{Alpha}*)?.jar$");
        for (String path : paths) {
            if (!pattern.matcher(path).find()) continue;
            return path;
        }
        return null;
    }

    private Matcher createFullyQualifiedMatcher() {
        String pathString = this.groupId.replace('.', this.fileSeparator) + this.fileSeparator + this.artifactId;
        Pattern p = Pattern.compile(this.classPathSeparatorRegex + Pattern.quote(pathString) + this.classPathSeparatorRegex, 2);
        return p.matcher(this.classPath);
    }

    private Matcher createUnqualifiedMatcher() {
        Pattern p = Pattern.compile(this.classPathSeparatorRegex + Pattern.quote("target" + this.fileSeparator + this.artifactId) + this.classPathSeparatorRegex, 2);
        return p.matcher(this.classPath);
    }

    private Matcher createTargetClassesMatcher() {
        Pattern p = Pattern.compile(this.classPathSeparatorRegex + Pattern.quote("target" + this.fileSeparator + "classes") + this.classPathSeparatorRegex, 2);
        return p.matcher(this.classPath);
    }
}

