/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.test;

import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.jboss.seam.persistence.test.HibernateSearchTestBase;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.ManagedPersistenceContextProvider;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityInjectionTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    EntityManagerFactory emf;

    public static Class<?>[] getTestClasses() {
        return new Class[]{HibernateSearchTestBase.class, Hotel.class, ManagedPersistenceContextProvider.class, HelloService.class, EntityInjectionTestBase.class};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInjectionIntoEntity() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        EntityManager em = null;
        try {
            em = this.emf.createEntityManager();
            this.transaction.begin();
            em.joinTransaction();
            Hotel h = new Hotel("Hilton", "Fake St", "Wollongong", "NSW", "2518", "Australia");
            em.persist((Object)h);
            em.flush();
            this.transaction.commit();
            em.close();
            this.transaction.begin();
            em = this.emf.createEntityManager();
            em.joinTransaction();
            h = (Hotel)em.createQuery("select h from Hotel h where h.name='Hilton'").getSingleResult();
            Assert.assertTrue((boolean)h.isInitalizerCalled());
            Assert.assertEquals((Object)h.sayHello(), (Object)"Hello");
        }
        finally {
            em.close();
            this.transaction.rollback();
        }
    }
}

