/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate.test;

import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import junit.framework.Assert;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.jboss.seam.persistence.FlushModeManager;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.Hotel;
import org.jboss.seam.persistence.test.util.ManagedHibernateSessionProvider;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedHibernateSessionFlushModeTestBase {
    @Inject
    FlushModeManager manager;
    @Inject
    Session session;
    @Inject
    ManagedPersistenceContext context;
    @Inject
    PersistenceContexts pc;
    @Inject
    BeanManager bm;

    public static Class<?>[] getTestClasses() {
        return new Class[]{ManagedHibernateSessionFlushModeTestBase.class, Hotel.class, ManagedHibernateSessionProvider.class, HelloService.class};
    }

    @Test
    public void testHibernateSessionDefaultFlushMode() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException {
        this.manager.setFlushModeType(FlushModeType.MANUAL);
        Assert.assertEquals((Object)FlushMode.MANUAL, (Object)this.session.getFlushMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChangedTouchedSessionFlushMode() {
        try {
            this.session.setFlushMode(FlushMode.AUTO);
            this.pc.changeFlushMode(FlushModeType.MANUAL);
            Assert.assertEquals((Object)FlushMode.MANUAL, (Object)this.session.getFlushMode());
        }
        finally {
            this.session.setFlushMode(FlushMode.AUTO);
        }
    }
}

