/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate.test;

import javax.inject.Inject;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.queryParser.MultiFieldQueryParser;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Version;
import org.hibernate.search.FullTextQuery;
import org.hibernate.search.FullTextSession;
import org.jboss.seam.persistence.test.util.HelloService;
import org.jboss.seam.persistence.test.util.IndexedHotel;
import org.jboss.seam.persistence.test.util.ManagedHibernateSessionProvider;
import org.jboss.seam.persistence.transaction.DefaultTransaction;
import org.jboss.seam.persistence.transaction.SeamTransaction;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateSearchTestBase {
    @Inject
    @DefaultTransaction
    SeamTransaction transaction;
    @Inject
    FullTextSession session;

    public static Class<?>[] getTestClasses() {
        return new Class[]{IndexedHotel.class, ManagedHibernateSessionProvider.class, HelloService.class, HibernateSearchTestBase.class};
    }

    @Test
    public void testSearchingForHotel() throws NotSupportedException, SystemException, SecurityException, IllegalStateException, RollbackException, HeuristicMixedException, HeuristicRollbackException, ParseException {
        this.transaction.begin();
        IndexedHotel h = new IndexedHotel("Hilton", "Fake St", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.commit();
        this.transaction.begin();
        h = new IndexedHotel("Other Hotel", "Real St ", "Wollongong", "NSW", "2518", "Australia");
        this.session.persist((Object)h);
        this.session.flush();
        this.transaction.commit();
        this.transaction.begin();
        String[] fields = new String[]{"name"};
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_30, fields, (Analyzer)new StandardAnalyzer(Version.LUCENE_30));
        Query query = parser.parse("Other");
        FullTextQuery persistenceQuery = this.session.createFullTextQuery(query, new Class[]{IndexedHotel.class});
        IndexedHotel hotel = (IndexedHotel)persistenceQuery.uniqueResult();
        Assert.assertTrue((boolean)hotel.getName().equals("Other Hotel"));
        this.transaction.commit();
    }
}

