/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.core;

import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import org.jboss.seam.mail.api.MailMessage;
import org.jboss.seam.mail.attachments.BaseAttachment;
import org.jboss.seam.mail.attachments.FileAttachment;
import org.jboss.seam.mail.attachments.InputStreamAttachment;
import org.jboss.seam.mail.core.EmailAttachment;
import org.jboss.seam.mail.core.EmailContact;
import org.jboss.seam.mail.core.EmailMessage;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.SendFailedException;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;
import org.jboss.seam.mail.core.enumerations.ContentType;
import org.jboss.seam.mail.core.enumerations.EmailMessageType;
import org.jboss.seam.mail.core.enumerations.MessagePriority;
import org.jboss.seam.mail.templating.MailContext;
import org.jboss.seam.mail.templating.TemplateProvider;
import org.jboss.seam.mail.util.EmailAttachmentUtil;
import org.jboss.seam.mail.util.MailUtility;

public class MailMessageImpl
implements MailMessage {
    private EmailMessage emailMessage;
    private TemplateProvider subjectTemplate;
    private TemplateProvider textTemplate;
    private TemplateProvider htmlTemplate;
    private Map<String, Object> templateContext = new HashMap<String, Object>();
    private boolean templatesMerged;
    @Inject
    private Instance<Session> session;

    public MailMessageImpl() {
        this.emailMessage = new EmailMessage();
    }

    public MailMessage from(String address) {
        this.emailMessage.addFromAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage from(String address, String name) {
        this.emailMessage.addFromAddress(MailUtility.internetAddress(address, name));
        return this;
    }

    public MailMessage from(InternetAddress emailAddress) {
        this.emailMessage.addFromAddress(emailAddress);
        return this;
    }

    public MailMessage from(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addFromAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage from(Collection<EmailContact> emailContacts) {
        this.emailMessage.addFromAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage replyTo(String address) {
        this.emailMessage.addReplyToAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage replyTo(String address, String name) {
        this.emailMessage.addReplyToAddress(MailUtility.internetAddress(address, name));
        return this;
    }

    public MailMessage replyTo(InternetAddress emailAddress) {
        this.emailMessage.addReplyToAddress(emailAddress);
        return this;
    }

    public MailMessage replyTo(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addReplyToAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage replyTo(Collection<EmailContact> emailContacts) {
        this.emailMessage.addReplyToAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage addHeader(String name, String value) {
        this.emailMessage.addHeader(new Header(name, value));
        return this;
    }

    public MailMessage to(String address) {
        this.emailMessage.addToAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage to(String address, String name) {
        this.emailMessage.addToAddress(MailUtility.internetAddress(address, name));
        return this;
    }

    public MailMessage to(InternetAddress emailAddress) {
        this.emailMessage.addToAddress(emailAddress);
        return this;
    }

    public MailMessage to(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addToAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage to(Collection<EmailContact> emailContacts) {
        this.emailMessage.addToAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage cc(String address) {
        this.emailMessage.addCcAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage cc(String address, String name) {
        this.emailMessage.addCcAddress(MailUtility.internetAddress(address, name));
        return this;
    }

    public MailMessage cc(InternetAddress emailAddress) {
        this.emailMessage.addCcAddress(emailAddress);
        return this;
    }

    public MailMessage cc(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addCcAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage cc(Collection<EmailContact> emailContacts) {
        this.emailMessage.addCcAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage bcc(String address) {
        this.emailMessage.addBccAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage bcc(String address, String name) {
        this.emailMessage.addBccAddress(MailUtility.internetAddress(address, name));
        return this;
    }

    public MailMessage bcc(InternetAddress emailAddress) {
        this.emailMessage.addBccAddress(emailAddress);
        return this;
    }

    public MailMessage bcc(EmailContact emailContact) {
        if (emailContact != null) {
            this.emailMessage.addBccAddress(MailUtility.internetAddress(emailContact));
        }
        return this;
    }

    public MailMessage bcc(Collection<EmailContact> emailContacts) {
        this.emailMessage.addBccAddresses(MailUtility.internetAddress(emailContacts));
        return this;
    }

    public MailMessage subject(String value) {
        this.emailMessage.setSubject(value);
        return this;
    }

    public MailMessage deliveryReceipt(String address) {
        this.emailMessage.addDeliveryReceiptAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage readReceipt(String address) {
        this.emailMessage.addReadReceiptAddress(MailUtility.internetAddress(address));
        return this;
    }

    public MailMessage importance(MessagePriority messagePriority) {
        this.emailMessage.setImportance(messagePriority);
        return this;
    }

    public MailMessage messageId(String messageId) {
        this.emailMessage.setMessageId(messageId);
        return this;
    }

    public MailMessage bodyText(String text) {
        this.emailMessage.setTextBody(text);
        return this;
    }

    public MailMessage bodyHtml(String html) {
        this.emailMessage.setHtmlBody(html);
        return this;
    }

    public MailMessage bodyHtmlTextAlt(String html, String text) {
        this.emailMessage.setTextBody(text);
        this.emailMessage.setHtmlBody(html);
        return this;
    }

    public MailMessage addAttachment(EmailAttachment attachment) {
        this.emailMessage.addAttachment(attachment);
        return this;
    }

    public MailMessage addAttachment(Collection<EmailAttachment> attachments) {
        this.emailMessage.addAttachments(attachments);
        return this;
    }

    public MailMessage addAttachment(String fileName, String mimeType, ContentDisposition contentDispostion, byte[] bytes) {
        this.addAttachment(new BaseAttachment(fileName, mimeType, contentDispostion, bytes));
        return this;
    }

    public MailMessage addAttachment(String fileName, String mimeType, ContentDisposition contentDispostion, InputStream inputStream) {
        this.addAttachment(new InputStreamAttachment(fileName, mimeType, contentDispostion, inputStream));
        return this;
    }

    public MailMessage addAttachment(ContentDisposition contentDispostion, File file) {
        this.addAttachment(new FileAttachment(contentDispostion, file));
        return this;
    }

    public MailMessage iCal(String html, byte[] bytes) {
        this.emailMessage.setType(EmailMessageType.INVITE_ICAL);
        this.emailMessage.setHtmlBody(html);
        this.emailMessage.addAttachment((EmailAttachment)new BaseAttachment(null, "text/calendar;method=CANCEL", ContentDisposition.INLINE, bytes, "urn:content-classes:calendarmessage"));
        return this;
    }

    public MailMessage subject(TemplateProvider subject) {
        this.subjectTemplate = subject;
        return this;
    }

    public MailMessage bodyText(TemplateProvider textBody) {
        this.textTemplate = textBody;
        return this;
    }

    public MailMessage bodyHtml(TemplateProvider htmlBody) {
        this.htmlTemplate = htmlBody;
        return this;
    }

    public MailMessage bodyHtmlTextAlt(TemplateProvider htmlBody, TemplateProvider textBody) {
        this.bodyHtml(htmlBody);
        this.bodyText(textBody);
        return this;
    }

    public MailMessage contentType(ContentType contentType) {
        this.emailMessage.setRootContentType(contentType);
        return this;
    }

    public MailMessage put(String key, Object value) {
        this.templateContext.put(key, value);
        return this;
    }

    public MailMessage put(Map<String, Object> values) {
        this.templateContext.putAll(values);
        return this;
    }

    public EmailMessage getEmailMessage() {
        return this.emailMessage;
    }

    public void setEmailMessage(EmailMessage emailMessage) {
        this.emailMessage = emailMessage;
    }

    public EmailMessage mergeTemplates() {
        this.put("mailContext", new MailContext(EmailAttachmentUtil.getEmailAttachmentMap(this.emailMessage.getAttachments())));
        if (this.subjectTemplate != null) {
            this.emailMessage.setSubject(this.subjectTemplate.merge(this.templateContext));
        }
        if (this.textTemplate != null) {
            this.emailMessage.setTextBody(this.textTemplate.merge(this.templateContext));
        }
        if (this.htmlTemplate != null) {
            this.emailMessage.setHtmlBody(this.htmlTemplate.merge(this.templateContext));
        }
        this.templatesMerged = true;
        return this.emailMessage;
    }

    public EmailMessage send(Session session) throws SendFailedException {
        if (!this.templatesMerged) {
            this.mergeTemplates();
        }
        MailUtility.send(this.emailMessage, session);
        return this.emailMessage;
    }

    public EmailMessage send() throws SendFailedException {
        return this.send((Session)this.session.get());
    }
}

