/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.jboss.seam.mail.attachments.AttachmentPart;
import org.jboss.seam.mail.core.EmailAttachment;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.RootMimeMessage;
import org.jboss.seam.mail.core.SendFailedException;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;
import org.jboss.seam.mail.core.enumerations.ContentType;
import org.jboss.seam.mail.core.enumerations.MailHeader;
import org.jboss.seam.mail.core.enumerations.MessagePriority;
import org.jboss.seam.mail.core.enumerations.RecipientType;
import org.jboss.seam.mail.util.MailUtility;

public class BaseMailMessage {
    private RootMimeMessage rootMimeMessage;
    private String charset;
    private ContentType rootContentType;
    private Map<String, AttachmentPart> attachments = new HashMap<String, AttachmentPart>();
    private MimeMultipart rootMultipart;
    private MimeMultipart relatedMultipart = new MimeMultipart(ContentType.RELATED.getValue());
    private Session session;

    public BaseMailMessage(Session session, ContentType rootContentType) {
        this.session = session;
        this.rootContentType = rootContentType;
        this.initialize();
    }

    public BaseMailMessage(Session session) {
        this(session, ContentType.MIXED);
    }

    private void initialize() {
        this.rootMimeMessage = new RootMimeMessage(this.session);
        this.rootMultipart = new MimeMultipart(this.rootContentType.getValue());
        this.charset = "UTF-8";
        this.setSentDate(new Date());
        try {
            this.rootMimeMessage.setContent((Multipart)this.rootMultipart);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to set RootMultiPart", e);
        }
        this.initializeMessageId();
    }

    public void addRecipient(RecipientType recipientType, InternetAddress emailAddress) {
        try {
            this.rootMimeMessage.addRecipient(recipientType.getRecipientType(), (Address)emailAddress);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add recipient " + recipientType + ": " + emailAddress.toString() + " to MIME message", e);
        }
    }

    public void addRecipients(RecipientType recipientType, InternetAddress[] emailAddresses) {
        try {
            this.rootMimeMessage.addRecipients(recipientType.getRecipientType(), (Address[])emailAddresses);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add " + recipientType + ":  Collection<Recipients>to MIME message", e);
        }
    }

    public void addRecipients(RecipientType recipientType, Collection<InternetAddress> emailAddresses) {
        try {
            this.rootMimeMessage.addRecipients(recipientType.getRecipientType(), (Address[])MailUtility.getInternetAddressses(emailAddresses));
        }
        catch (MessagingException messagingException) {
            // empty catch block
        }
    }

    public void setFrom(InternetAddress emailAddress) {
        try {
            this.rootMimeMessage.setFrom((Address)emailAddress);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to From Addresses", e);
        }
    }

    public BaseMailMessage setFrom(Collection<InternetAddress> emailAddresses) {
        try {
            if (emailAddresses.size() > 0) {
                this.rootMimeMessage.addFrom((Address[])MailUtility.getInternetAddressses(emailAddresses));
            }
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to From Addresses", e);
        }
        return this;
    }

    public void setReplyTo(String address) throws AddressException {
        this.setReplyTo(MailUtility.internetAddress(address));
    }

    public void setReplyTo(String name, String address) {
        this.setReplyTo(MailUtility.internetAddress(address, name));
    }

    public void setReplyTo(InternetAddress emailAddress) {
        ArrayList<InternetAddress> emailAddresses = new ArrayList<InternetAddress>();
        emailAddresses.add(emailAddress);
        this.setReplyTo(emailAddresses);
    }

    public void setReplyTo(Collection<InternetAddress> emailAddresses) {
        try {
            this.rootMimeMessage.setReplyTo((Address[])MailUtility.getInternetAddressses(emailAddresses));
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to set Reply-To", e);
        }
    }

    public void setSubject(String value) {
        this.setSubject(value, "UTF-8");
    }

    public void setSubject(String value, String charset) {
        try {
            this.rootMimeMessage.setSubject(value, charset);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add subject:" + value + " to MIME message with charset: " + charset, e);
        }
    }

    public void setSentDate(Date date) {
        try {
            this.rootMimeMessage.setSentDate(date);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to set Sent Date on MimeMessage", e);
        }
    }

    public void setMessageID(String messageId) {
        this.rootMimeMessage.setMessageId("<" + messageId + ">");
    }

    private void initializeMessageId() {
        String mailerDomainName = this.session.getProperty("mail.seam.domainName");
        if (mailerDomainName != null && mailerDomainName.length() > 0) {
            this.setMessageID(UUID.randomUUID().toString() + "@" + mailerDomainName);
        } else {
            this.setMessageID(UUID.randomUUID().toString() + "@" + MailUtility.getHostName());
        }
    }

    public void addDeliveryRecieptAddresses(Collection<InternetAddress> addresses) {
        for (InternetAddress address : addresses) {
            this.addDeliveryReciept(address.getAddress());
        }
    }

    public void addReadRecieptAddresses(Collection<InternetAddress> addresses) {
        for (InternetAddress address : addresses) {
            this.addReadReciept(address.getAddress());
        }
    }

    public void addDeliveryReciept(String address) {
        this.addHeader(new Header(MailHeader.DELIVERY_RECIEPT.headerValue(), "<" + address + ">"));
    }

    public void addReadReciept(String address) {
        this.addHeader(new Header(MailHeader.READ_RECIEPT.headerValue(), "<" + address + ">"));
    }

    public void setImportance(MessagePriority messagePriority) {
        if (messagePriority != null && messagePriority != MessagePriority.NORMAL) {
            this.setHeader(new Header("X-Priority", messagePriority.getX_priority()));
            this.setHeader(new Header("Priority", messagePriority.getPriority()));
            this.setHeader(new Header("Importance", messagePriority.getImportance()));
        }
    }

    public void setHeader(Header header) {
        try {
            this.rootMimeMessage.setHeader(header.getName(), header.getValue());
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to SET Header: + " + header.getName() + " to Value: " + header.getValue(), e);
        }
    }

    public void addHeaders(Collection<Header> headers) {
        for (Header header : headers) {
            this.addHeader(header);
        }
    }

    public void addHeader(Header header) {
        try {
            this.rootMimeMessage.addHeader(header.getName(), header.getValue());
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to ADD Header: + " + header.getName() + " to Value: " + header.getValue(), e);
        }
    }

    public void setText(String text) {
        try {
            this.rootMultipart.addBodyPart((BodyPart)this.buildTextBodyPart(text));
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add TextBody to MimeMessage", e);
        }
    }

    public void setHTML(String html) {
        MimeBodyPart relatedBodyPart = new MimeBodyPart();
        try {
            this.relatedMultipart.addBodyPart((BodyPart)this.buildHTMLBodyPart(html));
            relatedBodyPart.setContent((Multipart)this.relatedMultipart);
            this.rootMultipart.addBodyPart((BodyPart)relatedBodyPart);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add TextBody to MimeMessage", e);
        }
    }

    public void setHTMLNotRelated(String html) {
        try {
            this.rootMultipart.addBodyPart((BodyPart)this.buildHTMLBodyPart(html));
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add TextBody to MimeMessage", e);
        }
    }

    public void setHTMLTextAlt(String html, String text) {
        MimeBodyPart mixedBodyPart = new MimeBodyPart();
        MimeBodyPart relatedBodyPart = new MimeBodyPart();
        MimeMultipart alternativeMultiPart = new MimeMultipart(ContentType.ALTERNATIVE.getValue());
        try {
            alternativeMultiPart.addBodyPart((BodyPart)this.buildTextBodyPart(text));
            alternativeMultiPart.addBodyPart((BodyPart)this.buildHTMLBodyPart(html));
            relatedBodyPart.setContent((Multipart)alternativeMultiPart);
            this.relatedMultipart.addBodyPart((BodyPart)relatedBodyPart);
            mixedBodyPart.setContent((Multipart)this.relatedMultipart);
            this.rootMultipart.addBodyPart((BodyPart)mixedBodyPart);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to build HTML+Text Email", e);
        }
    }

    public void setCalendar(String body, AttachmentPart invite) {
        try {
            this.rootMultipart.addBodyPart((BodyPart)this.buildHTMLBodyPart(body));
            this.rootMultipart.addBodyPart((BodyPart)invite);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to add Calendar Body to MimeMessage", e);
        }
    }

    private MimeBodyPart buildTextBodyPart(String text) {
        MimeBodyPart textBodyPart = new MimeBodyPart();
        try {
            textBodyPart.setDisposition(ContentDisposition.INLINE.headerValue());
            textBodyPart.setText(text, this.charset);
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to build TextBodyPart", e);
        }
        return textBodyPart;
    }

    private MimeBodyPart buildHTMLBodyPart(String html) {
        MimeBodyPart htmlBodyPart = new MimeBodyPart();
        try {
            htmlBodyPart.setDisposition(ContentDisposition.INLINE.headerValue());
            htmlBodyPart.setText(html, this.charset, "html");
        }
        catch (MessagingException e) {
            throw new RuntimeException("Unable to build HTMLBodyPart", e);
        }
        return htmlBodyPart;
    }

    public void addAttachment(EmailAttachment emailAttachment) {
        AttachmentPart attachment = new AttachmentPart(emailAttachment.getBytes(), emailAttachment.getContentId(), emailAttachment.getFileName(), emailAttachment.getMimeType(), emailAttachment.getHeaders(), emailAttachment.getContentDisposition());
        this.attachments.put(attachment.getAttachmentFileName(), attachment);
    }

    public void addAttachments(Collection<EmailAttachment> emailAttachments) {
        for (EmailAttachment ea : emailAttachments) {
            this.addAttachment(ea);
        }
    }

    public Map<String, AttachmentPart> getAttachments() {
        return this.attachments;
    }

    public MimeMessage getRootMimeMessage() {
        return this.rootMimeMessage;
    }

    public void finalizeMessage() {
        this.addAttachmentsToMessage();
    }

    public MimeMessage getFinalizedMessage() {
        this.finalizeMessage();
        return this.getRootMimeMessage();
    }

    public void send() {
        this.finalizeMessage();
        try {
            Transport.send((Message)this.rootMimeMessage);
        }
        catch (MessagingException e) {
            throw new SendFailedException("Send Failed", (Throwable)e);
        }
    }

    private void addAttachmentsToMessage() {
        for (AttachmentPart a : this.attachments.values()) {
            if (a.getContentDisposition() == ContentDisposition.ATTACHMENT) {
                try {
                    this.rootMultipart.addBodyPart((BodyPart)a);
                    continue;
                }
                catch (MessagingException e) {
                    throw new RuntimeException("Unable to Add STANDARD Attachment: " + a.getAttachmentFileName(), e);
                }
            }
            if (a.getContentDisposition() == ContentDisposition.INLINE) {
                try {
                    if (this.relatedMultipart.getCount() > 0) {
                        this.relatedMultipart.addBodyPart((BodyPart)a);
                        continue;
                    }
                    this.rootMultipart.addBodyPart((BodyPart)a);
                    continue;
                }
                catch (MessagingException e) {
                    throw new RuntimeException("Unable to Add INLINE Attachment: " + a.getAttachmentFileName(), e);
                }
            }
            throw new RuntimeException("Unsupported Attachment Content Disposition");
        }
    }
}

