/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mail.attachments;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.activation.URLDataSource;
import org.jboss.seam.mail.attachments.BaseAttachment;
import org.jboss.seam.mail.core.AttachmentException;
import org.jboss.seam.mail.core.Header;
import org.jboss.seam.mail.core.enumerations.ContentDisposition;

public class URLAttachment
extends BaseAttachment {
    public URLAttachment(String url, String fileName, ContentDisposition contentDisposition) {
        try {
            URLDataSource uds = new URLDataSource(new URL(url));
            byte[] bytes = new byte[uds.getInputStream().available()];
            uds.getInputStream().read(bytes);
            super.setFileName(fileName);
            super.setMimeType(uds.getContentType());
            super.setContentDisposition(contentDisposition);
            super.setBytes(bytes);
        }
        catch (MalformedURLException e) {
            throw new AttachmentException("Wasn't able to create email attachment from URL: " + url, (Throwable)e);
        }
        catch (IOException e) {
            throw new AttachmentException("Wasn't able to create email attachment from URL: " + url, (Throwable)e);
        }
    }

    public URLAttachment(String url, String fileName, ContentDisposition contentDisposition, String contentClass) {
        this(url, fileName, contentDisposition);
        super.addHeader(new Header("Content-Class", contentClass));
    }
}

