/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.util.ArrayList;
import java.util.List;
import org.jboss.seam.web.Rewrite;
import org.jboss.seam.web.ServletMapping;

public class OutgoingPattern {
    String view;
    String pattern;
    ServletMapping viewMapping;
    List<String> parts = new ArrayList<String>();

    public OutgoingPattern(ServletMapping viewMapping, String view, String pattern) {
        this.view = view;
        this.pattern = pattern;
        this.viewMapping = viewMapping;
        this.parsePattern(pattern);
    }

    public Rewrite rewrite(String path) {
        return new OutgoingRewrite(path);
    }

    private void parsePattern(String value) {
        while (value.length() > 0) {
            int pos = value.indexOf(123);
            if (pos == -1) {
                this.parts.add(value);
                value = "";
                continue;
            }
            int pos2 = value.indexOf(125);
            if (pos2 == -1) {
                throw new IllegalArgumentException("invalid pattern");
            }
            this.parts.add(value.substring(0, pos));
            this.parts.add(value.substring(pos, pos2 + 1));
            value = value.substring(pos2 + 1);
        }
    }

    public class OutgoingRewrite
    implements Rewrite {
        Boolean isMatch;
        private String base;
        private List<String> queryArgs = new ArrayList<String>();
        private List<String> matchedArgs = new ArrayList<String>();

        public OutgoingRewrite(String outgoing) {
            int queryPos = outgoing.indexOf(63);
            if (queryPos == -1) {
                this.base = outgoing;
            } else {
                this.base = outgoing.substring(0, queryPos);
                this.parseArgs(outgoing.substring(queryPos + 1));
            }
        }

        private void parseArgs(String text) {
            String[] stringArray = text.split("\\&");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String part = stringArray[n2];
                this.queryArgs.add(part);
                ++n2;
            }
        }

        public boolean isMatch() {
            if (this.isMatch == null) {
                this.isMatch = this.match();
            }
            return this.isMatch;
        }

        private boolean match() {
            if (!OutgoingPattern.this.viewMapping.isMapped(this.base, OutgoingPattern.this.view)) {
                return false;
            }
            for (String part : OutgoingPattern.this.parts) {
                if (!part.startsWith("{") || !part.endsWith("}")) continue;
                String name = part.substring(1, part.length() - 1);
                String value = this.matchArg(name);
                if (value == null) {
                    return false;
                }
                this.matchedArgs.add(value);
            }
            return true;
        }

        private String matchArg(String argName) {
            int i = 0;
            while (i < this.queryArgs.size()) {
                int pos;
                String query = this.queryArgs.get(i);
                if (query.subSequence(0, pos = query.indexOf("=")).equals(argName)) {
                    this.queryArgs.remove(i);
                    return query.substring(pos + 1);
                }
                ++i;
            }
            return null;
        }

        public String rewrite() {
            StringBuffer res = new StringBuffer();
            int matchedPosition = 0;
            for (String part : OutgoingPattern.this.parts) {
                if (part.startsWith("{")) {
                    res.append(this.matchedArgs.get(matchedPosition++));
                    continue;
                }
                res.append(part);
            }
            int sep = 63;
            for (String arg : this.queryArgs) {
                res.append((char)sep).append(arg);
                sep = 38;
            }
            return res.toString();
        }
    }
}

