/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.jboss.seam.util.Reflections;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Conversions {
    private static final String EXPRESSION_MARKER = "#{";
    private static final char EXPRESSION_ESCAPE_CHAR = '\\';
    private static Map<Class, Converter> converters = new HashMap<Class, Converter>(){
        {
            this.put(String.class, new StringConverter());
            this.put(Boolean.class, new BooleanConverter());
            this.put(Boolean.TYPE, new BooleanConverter());
            this.put(Integer.class, new IntegerConverter());
            this.put(Integer.TYPE, new IntegerConverter());
            this.put(Long.class, new LongConverter());
            this.put(Long.TYPE, new LongConverter());
            this.put(Float.class, new FloatConverter());
            this.put(Float.TYPE, new FloatConverter());
            this.put(Double.class, new DoubleConverter());
            this.put(Double.TYPE, new DoubleConverter());
            this.put(Character.class, new CharacterConverter());
            this.put(Character.TYPE, new CharacterConverter());
            this.put(String[].class, new StringArrayConverter());
            this.put(Set.class, new SetConverter());
            this.put(List.class, new ListConverter());
            this.put(Map.class, new MapConverter());
            this.put(Properties.class, new PropertiesConverter());
            this.put(Enum.class, new EnumConverter());
            this.put(BigInteger.class, new BigIntegerConverter());
            this.put(BigDecimal.class, new BigDecimalConverter());
            this.put(Class.class, new ClassConverter());
        }
    };

    public static <Y> void putConverter(Class<Y> type, Converter<Y> converter) {
        converters.put(type, converter);
    }

    public static <Y> Converter<Y> getConverter(Class<Y> clazz) {
        Converter converter = converters.get(clazz);
        if (converter == null && clazz != null && clazz.isEnum()) {
            converter = converters.get(Enum.class);
        }
        if (converter == null) {
            throw new IllegalArgumentException("No converter for type: " + clazz.getName());
        }
        return converter;
    }

    private static Object getElementValue(Class elementType, Converter elementConverter, String string) {
        FlatPropertyValue propertyValue = new FlatPropertyValue(string);
        if (propertyValue.isExpression()) {
            throw new IllegalArgumentException("No expressions allowed here");
        }
        if (elementConverter == null) {
            throw new IllegalArgumentException("No converter for element type: " + elementType.getName());
        }
        return elementConverter.toObject(propertyValue, elementType);
    }

    public static class ArrayConverter
    implements Converter {
        public Object toObject(PropertyValue values, Type type) {
            String[] strings = values.getMultiValues();
            Class<?> elementType = ((Class)type).getComponentType();
            Object objects = Array.newInstance(elementType, strings.length);
            Converter elementConverter = (Converter)converters.get(elementType);
            int i = 0;
            while (i < strings.length) {
                Object element = elementConverter.toObject(new FlatPropertyValue(strings[i]), elementType);
                Array.set(objects, i, element);
                ++i;
            }
            return objects;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class AssociativePropertyValue
    implements PropertyValue {
        private Map<String, String> keyedValues;
        private Class type;

        public AssociativePropertyValue(Map<String, String> keyedValues, Class type) {
            if (keyedValues == null) {
                throw new IllegalArgumentException();
            }
            this.keyedValues = keyedValues;
            this.type = type;
        }

        @Override
        public String[] getMultiValues() {
            throw new UnsupportedOperationException("not a multi-valued property value");
        }

        @Override
        public String getSingleValue() {
            throw new UnsupportedOperationException("not a flat property value");
        }

        @Override
        public Map<String, String> getKeyedValues() {
            return this.keyedValues;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isAssociativeValued() {
            return true;
        }

        public String toString() {
            return this.keyedValues.toString();
        }

        @Override
        public Class getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigDecimalConverter
    implements Converter<BigDecimal> {
        @Override
        public BigDecimal toObject(PropertyValue value, Type type) {
            return new BigDecimal(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BigIntegerConverter
    implements Converter<BigInteger> {
        @Override
        public BigInteger toObject(PropertyValue value, Type type) {
            return new BigInteger(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BooleanConverter
    implements Converter<Boolean> {
        @Override
        public Boolean toObject(PropertyValue value, Type type) {
            return Boolean.valueOf(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CharacterConverter
    implements Converter<Character> {
        @Override
        public Character toObject(PropertyValue value, Type type) {
            return Character.valueOf(value.getSingleValue().charAt(0));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ClassConverter
    implements Converter<Class> {
        @Override
        public Class toObject(PropertyValue value, Type type) {
            try {
                return Reflections.classForName(value.getSingleValue());
            }
            catch (ClassNotFoundException cnfe) {
                throw new IllegalArgumentException(cnfe);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Converter<Z> {
        public Z toObject(PropertyValue var1, Type var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleConverter
    implements Converter<Double> {
        @Override
        public Double toObject(PropertyValue value, Type type) {
            return Double.valueOf(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumConverter
    implements Converter<Enum<?>> {
        @Override
        public Enum<?> toObject(PropertyValue value, Type type) {
            return Enum.valueOf((Class)type, value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlatPropertyValue
    implements PropertyValue {
        private String string;

        public FlatPropertyValue(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null value");
            }
            this.string = string;
        }

        @Override
        public String[] getMultiValues() {
            return Strings.split(this.string, ", \r\n\f\t");
        }

        @Override
        public String getSingleValue() {
            return this.string;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean isExpression() {
            block2: {
                containsExpr = false;
                idx = this.string.indexOf("#{");
                if (idx != 0) ** GOTO lbl11
                containsExpr = true;
                break block2;
lbl-1000:
                // 1 sources

                {
                    if (this.string.charAt(idx - 1) == '\\') {
                        idx = this.string.indexOf("#{", idx + 2);
                        continue;
                    }
                    containsExpr = true;
                    break;
lbl11:
                    // 2 sources

                    ** while (idx != -1)
                }
            }
            return containsExpr;
        }

        @Override
        public boolean isMultiValued() {
            return false;
        }

        @Override
        public boolean isAssociativeValued() {
            return false;
        }

        @Override
        public Map<String, String> getKeyedValues() {
            throw new UnsupportedOperationException("not a keyed property value");
        }

        public String toString() {
            return this.string;
        }

        @Override
        public Class getType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FloatConverter
    implements Converter<Float> {
        @Override
        public Float toObject(PropertyValue value, Type type) {
            return Float.valueOf(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IntegerConverter
    implements Converter<Integer> {
        @Override
        public Integer toObject(PropertyValue value, Type type) {
            return Integer.valueOf(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ListConverter
    implements Converter<List> {
        @Override
        public List toObject(PropertyValue values, Type type) {
            String[] strings = values.getMultiValues();
            Class elementType = Reflections.getCollectionElementType(type);
            ArrayList<Object> list = new ArrayList<Object>(strings.length);
            Converter elementConverter = (Converter)converters.get(elementType);
            int i = 0;
            while (i < strings.length) {
                list.add(Conversions.getElementValue(elementType, elementConverter, strings[i]));
                ++i;
            }
            return list;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LongConverter
    implements Converter<Long> {
        @Override
        public Long toObject(PropertyValue value, Type type) {
            return Long.valueOf(value.getSingleValue());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MapConverter
    implements Converter<Map> {
        @Override
        public Map toObject(PropertyValue values, Type type) {
            Map<String, String> keyedValues = values.getKeyedValues();
            Class elementType = Reflections.getCollectionElementType(type);
            HashMap<String, Object> map = new HashMap<String, Object>(keyedValues.size());
            Converter elementConverter = (Converter)converters.get(elementType);
            for (Map.Entry<String, String> me : keyedValues.entrySet()) {
                map.put(me.getKey(), Conversions.getElementValue(elementType, elementConverter, me.getValue()));
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MultiPropertyValue
    implements PropertyValue {
        private String[] strings;
        private Class type;

        public MultiPropertyValue(String[] strings, Class type) {
            if (strings == null) {
                throw new IllegalArgumentException();
            }
            this.strings = strings;
            this.type = type;
        }

        @Override
        public String[] getMultiValues() {
            return this.strings;
        }

        @Override
        public String getSingleValue() {
            throw new UnsupportedOperationException("not a flat property value");
        }

        @Override
        public Map<String, String> getKeyedValues() {
            throw new UnsupportedOperationException("not a keyed property value");
        }

        @Override
        public boolean isMultiValued() {
            return true;
        }

        @Override
        public boolean isAssociativeValued() {
            return false;
        }

        @Override
        public boolean isExpression() {
            return false;
        }

        public String toString() {
            return Strings.toString(", ", (Object[])this.strings);
        }

        @Override
        public Class getType() {
            return this.type;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PropertiesConverter
    implements Converter<Properties> {
        @Override
        public Properties toObject(PropertyValue values, Type type) {
            Map<String, String> keyedValues = values.getKeyedValues();
            Properties map = new Properties();
            Converter elementConverter = (Converter)converters.get(String.class);
            for (Map.Entry<String, String> me : keyedValues.entrySet()) {
                String key = me.getKey();
                Object element = elementConverter.toObject(new FlatPropertyValue(me.getValue()), (Type)((Object)String.class));
                map.put(key, element);
            }
            return map;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertyValue
    extends Serializable {
        public Map<String, String> getKeyedValues();

        public String[] getMultiValues();

        public String getSingleValue();

        public boolean isExpression();

        public boolean isMultiValued();

        public boolean isAssociativeValued();

        public Class getType();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SetConverter
    implements Converter<Set> {
        @Override
        public Set toObject(PropertyValue values, Type type) {
            String[] strings = values.getMultiValues();
            Class elementType = Reflections.getCollectionElementType(type);
            HashSet set = new HashSet(strings.length);
            Converter elementConverter = (Converter)converters.get(elementType);
            int i = 0;
            while (i < strings.length) {
                Object element = elementConverter.toObject(new FlatPropertyValue(strings[i]), elementType);
                set.add(element);
                ++i;
            }
            return set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringArrayConverter
    implements Converter<String[]> {
        @Override
        public String[] toObject(PropertyValue values, Type type) {
            return values.getMultiValues();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StringConverter
    implements Converter<String> {
        @Override
        public String toObject(PropertyValue value, Type type) {
            return value.getSingleValue();
        }
    }
}

