/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.transaction;

import javax.persistence.EntityManager;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Expressions;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.PersistenceProvider;
import org.jboss.seam.transaction.AbstractUserTransaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.transaction.transaction")
@Scope(value=ScopeType.EVENT)
@Install(value=false, precedence=10)
@BypassInterceptors
public class EntityTransaction
extends AbstractUserTransaction {
    private static final LogProvider log = Logging.getLogProvider(EntityTransaction.class);
    private Expressions.ValueExpression<EntityManager> entityManager;
    private EntityManager currentEntityManager;

    @Create
    public void validate() {
        if (this.entityManager == null) {
            this.entityManager = Expressions.instance().createValueExpression("#{entityManager}", EntityManager.class);
        }
    }

    private javax.persistence.EntityTransaction getDelegate() {
        if (this.currentEntityManager == null) {
            throw new IllegalStateException("entity manager is null");
        }
        return this.currentEntityManager.getTransaction();
    }

    private void initEntityManager() {
        this.currentEntityManager = this.entityManager.getValue();
        if (this.currentEntityManager == null) {
            throw new IllegalStateException("entity manager was null: " + this.entityManager.getExpressionString());
        }
    }

    public void begin() throws NotSupportedException, SystemException {
        log.debug("beginning JPA resource-local transaction");
        this.assertNotActive();
        this.initEntityManager();
        try {
            this.getDelegate().begin();
            EntityTransaction.getSynchronizations().afterTransactionBegin();
        }
        catch (RuntimeException re) {
            this.clearEntityManager();
            throw re;
        }
    }

    public void commit() throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException {
        log.debug("committing JPA resource-local transaction");
        this.assertActive();
        javax.persistence.EntityTransaction delegate = this.getDelegate();
        this.clearEntityManager();
        boolean success = false;
        try {
            if (delegate.getRollbackOnly()) {
                delegate.rollback();
                throw new RollbackException();
            }
            EntityTransaction.getSynchronizations().beforeTransactionCommit();
            delegate.commit();
            success = true;
        }
        finally {
            EntityTransaction.getSynchronizations().afterTransactionCommit(success);
        }
    }

    public void rollback() throws IllegalStateException, SecurityException, SystemException {
        log.debug("rolling back JPA resource-local transaction");
        this.assertActive();
        javax.persistence.EntityTransaction delegate = this.getDelegate();
        this.clearEntityManager();
        try {
            delegate.rollback();
        }
        finally {
            EntityTransaction.getSynchronizations().afterTransactionRollback();
        }
    }

    public void setRollbackOnly() throws IllegalStateException, SystemException {
        log.debug("marking JPA resource-local transaction for rollback");
        this.assertActive();
        this.getDelegate().setRollbackOnly();
    }

    public int getStatus() throws SystemException {
        if (this.isEntityManagerSet() && this.getDelegate().getRollbackOnly()) {
            return 1;
        }
        if (this.isEntityManagerSet() && this.getDelegate().isActive()) {
            return 0;
        }
        return 6;
    }

    public void setTransactionTimeout(int timeout) throws SystemException {
        throw new UnsupportedOperationException();
    }

    private boolean isEntityManagerSet() {
        return this.currentEntityManager != null;
    }

    private void clearEntityManager() {
        this.currentEntityManager = null;
    }

    private void assertActive() {
        if (!this.isEntityManagerSet()) {
            throw new IllegalStateException("transaction is not active");
        }
    }

    private void assertNotActive() throws NotSupportedException {
        if (this.isEntityManagerSet()) {
            throw new NotSupportedException("transaction is already active");
        }
    }

    @Override
    public void registerSynchronization(Synchronization sync) {
        if (log.isDebugEnabled()) {
            log.debug("registering synchronization: " + sync);
        }
        this.assertActive();
        if (!PersistenceProvider.instance().registerSynchronization(sync, this.currentEntityManager)) {
            EntityTransaction.getSynchronizations().registerSynchronization(sync);
        }
    }

    @Override
    public boolean isConversationContextRequired() {
        return true;
    }

    public Expressions.ValueExpression<EntityManager> getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(Expressions.ValueExpression<EntityManager> entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void enlist(EntityManager entityManager) {
    }
}

