/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.management;

import java.io.Serializable;
import java.security.Principal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.security.management.IdentityManagementException;
import org.jboss.seam.security.management.IdentityStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.security.identityStore")
@Install(precedence=0, value=false)
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
public class LdapIdentityStore
implements IdentityStore,
Serializable {
    private static final String LDAP_BOOLEAN_TRUE = "TRUE";
    private static final String LDAP_BOOLEAN_FALSE = "FALSE";
    private static final LogProvider log = Logging.getLogProvider(LdapIdentityStore.class);
    protected IdentityStore.FeatureSet featureSet = new IdentityStore.FeatureSet();
    private String serverAddress = "localhost";
    private int serverPort = 389;
    private String userContextDN = "ou=Person,dc=acme,dc=com";
    private String userDNPrefix = "uid=";
    private String userDNSuffix = ",ou=Person,dc=acme,dc=com";
    private String roleContextDN = "ou=Role,dc=acme,dc=com";
    private String roleDNPrefix = "cn=";
    private String roleDNSuffix = ",ou=Roles,dc=acme,dc=com";
    private String bindDN = "cn=Manager,dc=acme,dc=com";
    private String bindCredentials = "secret";
    private String userRoleAttribute = "roles";
    private boolean roleAttributeIsDN = true;
    private String userNameAttribute = "uid";
    private String userPasswordAttribute = "userPassword";
    private String firstNameAttribute = null;
    private String lastNameAttribute = "sn";
    private String fullNameAttribute = "cn";
    private String enabledAttribute = null;
    private String roleNameAttribute = "cn";
    private String objectClassAttribute = "objectClass";
    private String[] roleObjectClasses = new String[]{"organizationalRole"};
    private String[] userObjectClasses = new String[]{"person", "uidObject"};
    private String securityAuthenticationType = "simple";
    private int searchScope = 2;
    private int searchTimeLimit = 10000;

    public String getServerAddress() {
        return this.serverAddress;
    }

    public void setServerAddress(String serverAddress) {
        this.serverAddress = serverAddress;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(int serverPort) {
        this.serverPort = serverPort;
    }

    public String getUserContextDN() {
        return this.userContextDN;
    }

    public void setUserContextDN(String userContextDN) {
        this.userContextDN = userContextDN;
    }

    public String getRoleContextDN() {
        return this.roleContextDN;
    }

    public void setRoleContextDN(String roleContextDN) {
        this.roleContextDN = roleContextDN;
    }

    public String getUserDNPrefix() {
        return this.userDNPrefix;
    }

    public void setUserDNPrefix(String value) {
        this.userDNPrefix = value;
    }

    public String getUserDNSuffix() {
        return this.userDNSuffix;
    }

    public void setUserDNSuffix(String value) {
        this.userDNSuffix = value;
    }

    public String getRoleDNPrefix() {
        return this.roleDNPrefix;
    }

    public void setRoleDNPrefix(String value) {
        this.roleDNPrefix = value;
    }

    public String getRoleDNSuffix() {
        return this.roleDNSuffix;
    }

    public void setRoleDNSuffix(String value) {
        this.roleDNSuffix = value;
    }

    public String getBindDN() {
        return this.bindDN;
    }

    public void setBindDN(String bindDN) {
        this.bindDN = bindDN;
    }

    public String getBindCredentials() {
        return this.bindCredentials;
    }

    public void setBindCredentials(String bindCredentials) {
        this.bindCredentials = bindCredentials;
    }

    public String getUserRoleAttribute() {
        return this.userRoleAttribute;
    }

    public void setUserRoleAttribute(String userRoleAttribute) {
        this.userRoleAttribute = userRoleAttribute;
    }

    public boolean getRoleAttributeIsDN() {
        return this.roleAttributeIsDN;
    }

    public void setRoleAttributeIsDN(boolean value) {
        this.roleAttributeIsDN = value;
    }

    public String getRoleNameAttribute() {
        return this.roleNameAttribute;
    }

    public void setRoleNameAttribute(String roleNameAttribute) {
        this.roleNameAttribute = roleNameAttribute;
    }

    public String getUserNameAttribute() {
        return this.userNameAttribute;
    }

    public void setUserNameAttribute(String userNameAttribute) {
        this.userNameAttribute = userNameAttribute;
    }

    public String getUserPasswordAttribute() {
        return this.userPasswordAttribute;
    }

    public void setUserPasswordAttribute(String userPasswordAttribute) {
        this.userPasswordAttribute = userPasswordAttribute;
    }

    public String getFirstNameAttribute() {
        return this.firstNameAttribute;
    }

    public void setFirstNameAttribute(String firstNameAttribute) {
        this.firstNameAttribute = firstNameAttribute;
    }

    public String getLastNameAttribute() {
        return this.lastNameAttribute;
    }

    public void setLastNameAttribute(String lastNameAttribute) {
        this.lastNameAttribute = lastNameAttribute;
    }

    public String getFullNameAttribute() {
        return this.fullNameAttribute;
    }

    public void setFullNameAttribute(String fullNameAttribute) {
        this.fullNameAttribute = fullNameAttribute;
    }

    public String getEnabledAttribute() {
        return this.enabledAttribute;
    }

    public void setEnabledAttribute(String enabledAttribute) {
        this.enabledAttribute = enabledAttribute;
    }

    public String getObjectClassAttribute() {
        return this.objectClassAttribute;
    }

    public void setObjectClassAttribute(String objectClassAttribute) {
        this.objectClassAttribute = objectClassAttribute;
    }

    public String[] getRoleObjectClasses() {
        return this.roleObjectClasses;
    }

    public void setRoleObjectClass(String[] roleObjectClasses) {
        this.roleObjectClasses = roleObjectClasses;
    }

    public String[] getUserObjectClasses() {
        return this.userObjectClasses;
    }

    public void setUserObjectClasses(String[] userObjectClasses) {
        this.userObjectClasses = userObjectClasses;
    }

    public int getSearchTimeLimit() {
        return this.searchTimeLimit;
    }

    public void setSearchTimeLimit(int searchTimeLimit) {
        this.searchTimeLimit = searchTimeLimit;
    }

    public String getSecurityAuthenticationType() {
        return this.securityAuthenticationType;
    }

    public void setSecurityAuthenticationType(String value) {
        this.securityAuthenticationType = value;
    }

    public String getSearchScope() {
        switch (this.searchScope) {
            case 0: {
                return "OBJECT_SCOPE";
            }
            case 1: {
                return "ONELEVEL_SCOPE";
            }
            case 2: {
                return "SUBTREE_SCOPE";
            }
        }
        return "UNKNOWN";
    }

    public void setSearchScope(String value) {
        if ("OBJECT_SCOPE".equals(value)) {
            this.searchScope = 0;
        } else if ("ONELEVEL_SCOPE".equals(value)) {
            this.searchScope = 1;
        } else {
            this.searchScope = 2;
            if (!"SUBTREE_SCOPE".equals(value)) {
                log.warn("Invalid search scope specified (" + value + ") - search scope set to SUBTREE_SCOPE");
            }
        }
    }

    public Set<IdentityStore.Feature> getFeatures() {
        return this.featureSet.getFeatures();
    }

    public void setFeatures(Set<IdentityStore.Feature> features) {
        this.featureSet = new IdentityStore.FeatureSet(features);
    }

    @Override
    public boolean supportsFeature(IdentityStore.Feature feature) {
        return this.featureSet.supports(feature);
    }

    protected final InitialLdapContext initialiseContext() throws NamingException {
        return this.initialiseContext(this.getBindDN(), this.getBindCredentials());
    }

    protected final InitialLdapContext initialiseContext(String principal, String credentials) throws NamingException {
        Properties env = new Properties();
        env.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.setProperty("java.naming.security.authentication", this.securityAuthenticationType);
        String providerUrl = String.format("ldap://%s:%d", this.getServerAddress(), this.getServerPort());
        env.setProperty("java.naming.provider.url", providerUrl);
        env.setProperty("java.naming.security.principal", principal);
        env.setProperty("java.naming.security.credentials", credentials);
        InitialLdapContext ctx = new InitialLdapContext(env, null);
        return ctx;
    }

    protected String getUserDN(String username) {
        return String.format("%s%s%s", this.getUserDNPrefix(), username, this.getUserDNSuffix());
    }

    protected String getRoleDN(String role) {
        return String.format("%s%s%s", this.getRoleDNPrefix(), role, this.getRoleDNSuffix());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean authenticate(String username, String password) {
        InitialLdapContext ctx;
        block16: {
            block15: {
                String securityPrincipal = this.getUserDN(username);
                ctx = null;
                try {
                    ctx = this.initialiseContext(securityPrincipal, password);
                    if (this.getEnabledAttribute() == null) {
                        if (ctx == null) return true;
                        break block15;
                    }
                    Attributes attribs = ctx.getAttributes(securityPrincipal, new String[]{this.getEnabledAttribute()});
                    Attribute enabledAttrib = attribs.get(this.getEnabledAttribute());
                    if (enabledAttrib != null) {
                        int r = 0;
                    }
                    if (ctx == null) return false;
                    break block16;
                }
                catch (NamingException ex) {
                    throw new IdentityManagementException("Authentication error", ex);
                }
            }
            try {
                ctx.close();
                return true;
            }
            catch (NamingException namingException) {}
            return true;
        }
        try {
            ctx.close();
            return false;
        }
        catch (NamingException namingException) {}
        return false;
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean changePassword(String name, String password) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttribute passwordAttrib = new BasicAttribute(this.getUserPasswordAttribute(), password);
            ModificationItem mod = new ModificationItem(2, passwordAttrib);
            ctx.modifyAttributes(this.getUserDN(name), new ModificationItem[]{mod});
            if (ctx == null) return true;
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to change password", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createRole(String role) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttributes roleAttribs = new BasicAttributes();
            BasicAttribute roleClass = new BasicAttribute(this.getObjectClassAttribute());
            String[] stringArray = this.getRoleObjectClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    roleAttribs.put(roleClass);
                    roleAttribs.put(new BasicAttribute(this.getRoleNameAttribute(), role));
                    String roleDN = this.getRoleDN(role);
                    ctx.createSubcontext(roleDN, (Attributes)roleAttribs);
                    if (ctx == null) return true;
                    break;
                }
                String objectClass = stringArray[n2];
                roleClass.add(objectClass);
                ++n2;
            }
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to create role", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean createUser(String username, String password, String firstname, String lastname) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            BasicAttributes userAttribs = new BasicAttributes();
            BasicAttribute userClass = new BasicAttribute(this.getObjectClassAttribute());
            String[] stringArray = this.getUserObjectClasses();
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    userAttribs.put(userClass);
                    userAttribs.put(new BasicAttribute(this.getUserNameAttribute(), username));
                    userAttribs.put(new BasicAttribute(this.getUserPasswordAttribute(), password));
                    if (this.getFirstNameAttribute() != null && firstname != null) {
                        userAttribs.put(new BasicAttribute(this.getFirstNameAttribute(), firstname));
                    }
                    if (this.getLastNameAttribute() != null && lastname != null) {
                        userAttribs.put(new BasicAttribute(this.getLastNameAttribute(), lastname));
                    }
                    if (this.getFullNameAttribute() != null && firstname != null && lastname != null) {
                        userAttribs.put(new BasicAttribute(this.getFullNameAttribute(), String.valueOf(firstname) + " " + lastname));
                    }
                    if (this.getEnabledAttribute() != null) {
                        userAttribs.put(new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_TRUE));
                    }
                    String userDN = String.format("%s=%s,%s", this.getUserNameAttribute(), username, this.getUserContextDN());
                    ctx.createSubcontext(userDN, (Attributes)userAttribs);
                    if (ctx == null) return true;
                    break;
                }
                String objectClass = stringArray[n2];
                userClass.add(objectClass);
                ++n2;
            }
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to create user", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    @Override
    public boolean createUser(String username, String password) {
        return this.createUser(username, password, null, null);
    }

    /*
     * Loose catch block
     */
    @Override
    public boolean deleteRole(String role) {
        InitialLdapContext ctx;
        block11: {
            ctx = null;
            ctx = this.initialiseContext();
            String roleDN = String.format("%s=%s,%s", this.getRoleNameAttribute(), role, this.getRoleContextDN());
            ctx.destroySubcontext(roleDN);
            int searchScope = 2;
            int searchTimeLimit = 10000;
            String[] roleAttr = new String[]{this.getUserRoleAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(searchTimeLimit);
            StringBuilder roleFilter = new StringBuilder();
            Object[] filterArgs = new Object[this.getUserObjectClasses().length + 1];
            filterArgs[0] = roleDN;
            roleFilter.append("(&(");
            roleFilter.append(this.getUserRoleAttribute());
            roleFilter.append("={0})");
            int i = 0;
            while (i < this.getUserObjectClasses().length) {
                roleFilter.append("(");
                roleFilter.append(this.getObjectClassAttribute());
                roleFilter.append("={");
                roleFilter.append(i + 1);
                roleFilter.append("})");
                filterArgs[i + 1] = this.getUserObjectClasses()[i];
                ++i;
            }
            roleFilter.append(")");
            NamingEnumeration<SearchResult> answer = ctx.search(this.getUserContextDN(), roleFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getUserRoleAttribute());
                user.remove(roleDN);
                ctx.modifyAttributes(sr.getNameInNamespace(), new ModificationItem[]{new ModificationItem(2, user)});
            }
            answer.close();
            if (ctx == null) break block11;
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return true;
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to delete role", ex);
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean roleExists(String role) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean deleteUser(String name) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            ctx.destroySubcontext(userDN);
            if (ctx == null) return true;
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to delete user", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isUserEnabled(String name) {
        if (this.getEnabledAttribute() == null) {
            return true;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            Attributes attribs = ctx.getAttributes(userDN, new String[]{this.getEnabledAttribute()});
            Attribute enabledAttrib = attribs.get(this.getEnabledAttribute());
            if (enabledAttrib != null) {
                int r = 0;
            }
            if (ctx == null) return false;
        }
        catch (NamingException ex) {
            throw new IdentityManagementException("Failed to delete user", ex);
        }
        try {
            ctx.close();
            return false;
        }
        catch (NamingException namingException) {}
        return false;
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean disableUser(String name) {
        if (this.getEnabledAttribute() == null) {
            return false;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute enabledAttrib = new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_FALSE);
            ModificationItem mod = new ModificationItem(2, enabledAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            if (ctx == null) return true;
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to disable user", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean enableUser(String name) {
        if (this.getEnabledAttribute() == null) {
            return false;
        }
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute enabledAttrib = new BasicAttribute(this.getEnabledAttribute(), LDAP_BOOLEAN_TRUE);
            ModificationItem mod = new ModificationItem(2, enabledAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            if (ctx == null) return true;
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to disable user", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public List<String> getGrantedRoles(String name) {
        block16: {
            userRoles = new HashSet<String>();
            ctx = null;
            ctx = this.initialiseContext();
            userFilter = "(" + this.getUserNameAttribute() + "={0})";
            roleAttr = new String[]{this.getUserRoleAttribute()};
            controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            filterArgs = new Object[]{name};
            answer = ctx.search(this.getUserContextDN(), userFilter, filterArgs, controls);
            while (answer.hasMore()) {
                sr = answer.next();
                attrs = sr.getAttributes();
                roles = attrs.get(this.getUserRoleAttribute());
                if (roles == null) continue;
                r = 0;
                while (r < roles.size()) {
                    value = roles.get(r);
                    roleName = null;
                    if (this.getRoleAttributeIsDN()) {
                        roleDN = value.toString();
                        returnAttribute = new String[]{this.getRoleNameAttribute()};
                        try {
                            result2 = ctx.getAttributes(roleDN, returnAttribute);
                            roles2 = result2.get(this.getRoleNameAttribute());
                            if (roles2 == null) ** GOTO lbl42
                            m = 0;
                            while (m < roles2.size()) {
                                roleName = (String)roles2.get(m);
                                userRoles.add(roleName);
                                ++m;
                            }
                        }
                        catch (NamingException ex) {
                            throw new IdentityManagementException("Failed to query roles", ex);
                        }
                    } else {
                        roleName = value.toString();
                        userRoles.add(roleName);
                    }
lbl42:
                    // 3 sources

                    ++r;
                }
            }
            answer.close();
            var21_22 = new ArrayList<String>(userRoles);
            if (ctx == null) break block16;
            try {
                ctx.close();
            }
            catch (NamingException v0) {}
        }
        return var21_22;
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Error getting roles", ex);
            }
            catch (Throwable var20_23) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException v1) {}
                }
                throw var20_23;
            }
        }
    }

    @Override
    public List<String> getImpliedRoles(String name) {
        return this.getGrantedRoles(name);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean grantRole(String name, String role) {
        InitialLdapContext ctx = null;
        try {
            ctx = this.initialiseContext();
            String userDN = this.getUserDN(name);
            BasicAttribute roleAttrib = new BasicAttribute(this.getUserRoleAttribute(), this.getRoleAttributeIsDN() ? this.getRoleDN(role) : role);
            ModificationItem mod = new ModificationItem(1, roleAttrib);
            ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
            if (ctx == null) return true;
        }
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Failed to grant role", ex);
            }
            catch (Throwable throwable) {
                if (ctx == null) throw throwable;
                try {
                    ctx.close();
                    throw throwable;
                }
                catch (NamingException namingException) {}
                throw throwable;
            }
        }
        try {
            ctx.close();
            return true;
        }
        catch (NamingException namingException) {}
        return true;
    }

    @Override
    public boolean revokeRole(String name, String role) {
        InitialLdapContext ctx = null;
        try {
            try {
                ctx = this.initialiseContext();
                String userDN = this.getUserDN(name);
                Attributes roleAttribs = ctx.getAttributes(userDN, new String[]{this.getUserRoleAttribute()});
                Attribute roleAttrib = roleAttribs.get(this.getUserRoleAttribute());
                if (roleAttrib != null) {
                    boolean modified = false;
                    int i = roleAttrib.size() - 1;
                    while (i >= 0) {
                        if (this.getRoleAttributeIsDN()) {
                            Attributes attribs = ctx.getAttributes((String)roleAttrib.get(i), new String[]{this.getRoleNameAttribute()});
                            Attribute roleNameAttrib = attribs.get(this.getRoleNameAttribute());
                            int j = 0;
                            while (j < roleNameAttrib.size()) {
                                if (role.equals(roleNameAttrib.get(j))) {
                                    modified = true;
                                    roleAttrib.remove(i);
                                }
                                ++j;
                            }
                        } else if (role.equals(roleAttrib.get(i))) {
                            modified = true;
                            roleAttrib.remove(i);
                        }
                        --i;
                    }
                    if (modified) {
                        ModificationItem mod = new ModificationItem(2, roleAttrib);
                        ctx.modifyAttributes(userDN, new ModificationItem[]{mod});
                    }
                }
            }
            catch (NamingException ex) {
                throw new IdentityManagementException("Failed to grant role", ex);
            }
        }
        catch (Throwable throwable) {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException namingException) {}
            }
            throw throwable;
        }
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return false;
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> listRoles() {
        ArrayList<String> arrayList;
        InitialLdapContext ctx;
        block12: {
            ArrayList<String> roles = new ArrayList<String>();
            ctx = null;
            ctx = this.initialiseContext();
            String[] roleAttr = new String[]{this.getRoleNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(roleAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            StringBuilder roleFilter = new StringBuilder();
            Object[] filterArgs = new Object[this.getRoleObjectClasses().length];
            int i = 0;
            while (i < this.getRoleObjectClasses().length) {
                roleFilter.append("(");
                roleFilter.append(this.getObjectClassAttribute());
                roleFilter.append("={");
                roleFilter.append(i);
                roleFilter.append("})");
                filterArgs[i] = this.getRoleObjectClasses()[i];
                ++i;
            }
            NamingEnumeration<SearchResult> answer = ctx.search(this.getRoleContextDN(), roleFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getRoleNameAttribute());
                int i2 = 0;
                while (i2 < user.size()) {
                    Object value = user.get(i2);
                    roles.add(value.toString());
                    ++i2;
                }
            }
            answer.close();
            arrayList = roles;
            if (ctx == null) break block12;
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return arrayList;
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Error getting roles", ex);
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
                throw throwable;
            }
        }
    }

    @Override
    public List<String> listGrantableRoles() {
        return this.listRoles();
    }

    @Override
    public List<String> listUsers() {
        return this.listUsers(null);
    }

    /*
     * Loose catch block
     */
    @Override
    public List<String> listUsers(String filter) {
        ArrayList<String> arrayList;
        InitialLdapContext ctx;
        block15: {
            ArrayList<String> users = new ArrayList<String>();
            ctx = null;
            ctx = this.initialiseContext();
            String[] userAttr = new String[]{this.getUserNameAttribute()};
            SearchControls controls = new SearchControls();
            controls.setSearchScope(this.searchScope);
            controls.setReturningAttributes(userAttr);
            controls.setTimeLimit(this.getSearchTimeLimit());
            StringBuilder userFilter = new StringBuilder("(&");
            Object[] filterArgs = new Object[this.getUserObjectClasses().length];
            int i = 0;
            while (i < this.getUserObjectClasses().length) {
                userFilter.append("(");
                userFilter.append(this.getObjectClassAttribute());
                userFilter.append("={");
                userFilter.append(i);
                userFilter.append("})");
                filterArgs[i] = this.getUserObjectClasses()[i];
                ++i;
            }
            userFilter.append(")");
            NamingEnumeration<SearchResult> answer = ctx.search(this.getUserContextDN(), userFilter.toString(), filterArgs, controls);
            while (answer.hasMore()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                Attribute user = attrs.get(this.getUserNameAttribute());
                int i2 = 0;
                while (i2 < user.size()) {
                    Object value = user.get(i2);
                    if (filter != null) {
                        if (value.toString().toLowerCase().contains(filter.toLowerCase())) {
                            users.add(value.toString());
                        }
                    } else {
                        users.add(value.toString());
                    }
                    ++i2;
                }
            }
            answer.close();
            arrayList = users;
            if (ctx == null) break block15;
            try {
                ctx.close();
            }
            catch (NamingException namingException) {}
        }
        return arrayList;
        catch (NamingException ex) {
            try {
                throw new IdentityManagementException("Error getting users", ex);
            }
            catch (Throwable throwable) {
                if (ctx != null) {
                    try {
                        ctx.close();
                    }
                    catch (NamingException namingException) {}
                }
                throw throwable;
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean userExists(String name) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 12[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<String> getRoleGroups(String name) {
        return null;
    }

    @Override
    public List<Principal> listMembers(String role) {
        return null;
    }

    @Override
    public boolean addRoleToGroup(String role, String group) {
        return false;
    }

    @Override
    public boolean removeRoleFromGroup(String role, String group) {
        return false;
    }
}

