/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.digest;

import org.jboss.seam.security.digest.DigestUtils;
import org.jboss.seam.security.digest.DigestValidationException;
import org.jboss.seam.util.Base64;

public class DigestRequest {
    public static final String DIGEST_REQUEST = "org.jboss.seam.security.digestRequest";
    private boolean passwordAlreadyEncoded;
    private String systemRealm;
    private String realm;
    private String key;
    private String password;
    private String uri;
    private String qop;
    private String nonce;
    private String nonceCount;
    private String clientNonce;
    private String httpMethod;
    private String clientDigest;

    public String getClientNonce() {
        return this.clientNonce;
    }

    public void setClientNonce(String clientNonce) {
        this.clientNonce = clientNonce;
    }

    public String getNonce() {
        return this.nonce;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public String getNonceCount() {
        return this.nonceCount;
    }

    public void setNonceCount(String nonceCount) {
        this.nonceCount = nonceCount;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public boolean isPasswordAlreadyEncoded() {
        return this.passwordAlreadyEncoded;
    }

    public void setPasswordAlreadyEncoded(boolean passwordAlreadyEncoded) {
        this.passwordAlreadyEncoded = passwordAlreadyEncoded;
    }

    public String getQop() {
        return this.qop;
    }

    public void setQop(String qop) {
        this.qop = qop;
    }

    public String getRealm() {
        return this.realm;
    }

    public String getSystemRealm() {
        return this.systemRealm;
    }

    public void setSystemRealm(String systemRealm) {
        this.systemRealm = systemRealm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getClientDigest() {
        return this.clientDigest;
    }

    public void setClientDigest(String clientDigest) {
        this.clientDigest = clientDigest;
    }

    public void validate() throws DigestValidationException {
        String nonceAsText;
        String[] nonceTokens;
        if (this.realm == null) {
            throw new DigestValidationException("Mandatory field 'realm' not specified");
        }
        if (this.nonce == null) {
            throw new DigestValidationException("Mandatory field 'nonce' not specified");
        }
        if (this.uri == null) {
            throw new DigestValidationException("Mandatory field 'uri' not specified");
        }
        if (this.clientDigest == null) {
            throw new DigestValidationException("Mandatory field 'response' not specified");
        }
        if ("auth".equals(this.qop)) {
            if (this.nonceCount == null) {
                throw new DigestValidationException("Mandatory field 'nc' not specified");
            }
            if (this.clientNonce == null) {
                throw new DigestValidationException("Mandatory field 'cnonce' not specified");
            }
        }
        if ((nonceTokens = (nonceAsText = new String(Base64.decode(this.nonce))).split(":")).length != 2) {
            throw new DigestValidationException("Nonce should provide two tokens - nonce received: " + this.nonce);
        }
        if (!this.systemRealm.equals(this.realm)) {
            throw new DigestValidationException("Realm name [" + this.realm + "] does not match system realm name [" + this.systemRealm + "]");
        }
        long nonceExpiry = 0L;
        try {
            nonceExpiry = new Long(nonceTokens[0]);
        }
        catch (NumberFormatException numberFormatException) {
            throw new DigestValidationException("First nonce token should be numeric, but was: " + nonceTokens[0]);
        }
        if (nonceExpiry < System.currentTimeMillis()) {
            throw new DigestValidationException("Nonce has expired", true);
        }
        String expectedNonceSignature = DigestUtils.md5Hex(String.valueOf(nonceExpiry) + ":" + this.key);
        if (!expectedNonceSignature.equals(nonceTokens[1])) {
            throw new DigestValidationException("Nonce token invalid: " + nonceAsText);
        }
    }
}

