/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Map;
import org.jboss.seam.Component;
import org.jboss.seam.Seam;
import org.jboss.seam.annotations.In;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.PersistenceContexts;
import org.jboss.seam.util.JSF;
import org.jboss.seam.util.Reflections;

public class ManagedEntityWrapper {
    private static LogProvider log = Logging.getLogProvider(ManagedEntityWrapper.class);

    public void wrap(Object target, Component component) throws Exception {
        if (!this.touchedContextsExist()) {
            log.trace("No touched persistence contexts. Therefore, there are no entities in this conversation whose identities need to be preserved.");
            return;
        }
        String oldCid = this.switchToConversationContextOfComponent(component);
        Class<?> beanClass = target.getClass();
        while (beanClass != Object.class) {
            log.trace("Examining fields on " + beanClass);
            Field[] fieldArray = beanClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!this.ignore(field)) {
                    Object value = this.getFieldValue(target, field);
                    if (value != null) {
                        Object dataModel = null;
                        if (JSF.DATA_MODEL.isInstance(value)) {
                            dataModel = value;
                            value = JSF.getWrappedData(dataModel);
                        }
                        if (this.containsReferenceToEntityInstance(value)) {
                            log.trace("Attempting to save wrapper for " + field + " (" + value + ")");
                            this.saveWrapper(target, component, field, dataModel, value);
                        } else {
                            log.trace("Clearing wrapper for " + field + " (" + value + ") as it isn't a entity reference");
                            this.clearWrapper(component, field);
                        }
                    } else {
                        log.trace("Clearing wrapper for " + field + " as it is null");
                        this.clearWrapper(component, field);
                    }
                } else {
                    log.trace("Ignoring field " + field + " as it is static, transient or annotated with @In");
                }
                ++n2;
            }
            beanClass = beanClass.getSuperclass();
        }
        this.restorePreviousConversationContextIfNecessary(oldCid);
    }

    public void deserialize(Object controllerBean, Component component) throws Exception {
        if (!this.touchedContextsExist()) {
            log.trace("No touched persistence contexts. Therefore, there are no entities in this conversation whose identities need to be restored.");
            return;
        }
        Class<?> beanClass = controllerBean.getClass();
        while (beanClass != Object.class) {
            log.trace("Examining fields on " + beanClass);
            Field[] fieldArray = beanClass.getDeclaredFields();
            int n = fieldArray.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (!this.ignore(field)) {
                    Object value = this.getFieldValue(controllerBean, field);
                    Object dataModel = null;
                    if (value != null && JSF.DATA_MODEL.isInstance(value)) {
                        dataModel = value;
                    }
                    log.trace("Attempting to restore wrapper for " + field + " (" + value + ")");
                    this.getFromWrapper(controllerBean, component, field, dataModel);
                } else {
                    log.trace("Ignoring field " + field + " as it is static, transient or annotated with @In");
                }
                ++n2;
            }
            beanClass = beanClass.getSuperclass();
        }
    }

    private boolean containsReferenceToEntityInstance(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            for (Object v : (Collection)value) {
                if (v == null || Seam.getEntityClass(v.getClass()) == null) continue;
                return true;
            }
            return false;
        }
        if (value instanceof Map) {
            for (Map.Entry e : ((Map)value).entrySet()) {
                if ((e.getKey() == null || Seam.getEntityClass(e.getKey().getClass()) == null) && (e.getValue() == null || Seam.getEntityClass(e.getValue().getClass()) == null)) continue;
                return true;
            }
            return false;
        }
        return Seam.getEntityClass(value.getClass()) != null;
    }

    private Object getFieldValue(Object bean, Field field) throws Exception {
        if (!field.isAccessible()) {
            field.setAccessible(true);
        }
        Object value = Reflections.get(field, bean);
        return value;
    }

    private boolean ignore(Field field) {
        return Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || field.isAnnotationPresent(In.class);
    }

    private boolean touchedContextsExist() {
        PersistenceContexts touchedContexts = PersistenceContexts.instance();
        return touchedContexts != null && touchedContexts.getTouchedContexts().size() > 0;
    }

    private String getFieldId(Component component, Field field) {
        return String.valueOf(component.getName()) + '.' + field.getName();
    }

    private void saveWrapper(Object bean, Component component, Field field, Object dataModel, Object value) throws Exception {
        Contexts.getConversationContext().set(this.getFieldId(component, field), value);
        if (dataModel == null) {
            Reflections.set(field, bean, null);
        }
    }

    private void clearWrapper(Component component, Field field) throws Exception {
        Contexts.getConversationContext().remove(this.getFieldId(component, field));
    }

    private void getFromWrapper(Object bean, Component component, Field field, Object dataModel) throws Exception {
        Object value = Contexts.getConversationContext().get(this.getFieldId(component, field));
        if (value != null) {
            if (dataModel == null) {
                Reflections.set(field, bean, value);
            } else {
                JSF.setWrappedData(dataModel, value);
            }
        }
    }

    private String switchToConversationContextOfComponent(Component component) {
        String residentCid;
        String currentCid;
        Manager manager = Manager.instance();
        if (manager.isNestedConversation() && !(currentCid = manager.getCurrentConversationId()).equals(residentCid = manager.getCurrentConversationEntry().findPositionInConversationStack(component))) {
            Contexts.getConversationContext().flush();
            Manager.instance().switchConversation(residentCid, false);
            return currentCid;
        }
        return null;
    }

    private void restorePreviousConversationContextIfNecessary(String oldCid) {
        if (oldCid != null) {
            Contexts.getConversationContext().flush();
            Manager.instance().switchConversation(oldCid, false);
        }
    }
}

