/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.persistence.ManagedEntityWrapper;
import org.jboss.seam.transaction.Transaction;

@Interceptor(around={BijectionInterceptor.class})
public class ManagedEntityInterceptor
extends AbstractInterceptor {
    private static LogProvider log = Logging.getLogProvider(ManagedEntityInterceptor.class);
    private static ManagedEntityWrapper managedEntityWrapper = new ManagedEntityWrapper();
    private boolean reentrant;

    @AroundInvoke
    public Object aroundInvoke(InvocationContext ctx) throws Exception {
        if (this.reentrant) {
            return ctx.proceed();
        }
        this.reentrant = true;
        log.trace("Attempting to activate " + this.getComponent().getName() + " component");
        managedEntityWrapper.deserialize(ctx.getTarget(), this.getComponent());
        log.debug("Activated " + this.getComponent().getName() + " component");
        try {
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (!ManagedEntityInterceptor.isTransactionRolledBackOrMarkedRollback()) {
                log.trace("Attempting to passivate " + this.getComponent().getName() + " component");
                managedEntityWrapper.wrap(ctx.getTarget(), this.getComponent());
                this.reentrant = false;
                log.debug("Passivated " + this.getComponent().getName() + " component");
            }
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().getScope() == ScopeType.CONVERSATION;
    }

    private static boolean isTransactionRolledBackOrMarkedRollback() {
        try {
            return Transaction.instance().isRolledBackOrMarkedRollback();
        }
        catch (Exception exception) {
            return false;
        }
    }
}

