/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.mock;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ReplacementDataSet;
import org.dbunit.dataset.datatype.DataType;
import org.dbunit.dataset.datatype.DataTypeException;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.operation.DatabaseOperation;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.mock.SeamTest;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DBUnitSeamTest
extends SeamTest {
    private LogProvider log = Logging.getLogProvider(DBUnitSeamTest.class);
    protected String datasourceJndiName;
    protected String binaryDir;
    protected Database database = Database.HSQL;
    protected boolean replaceNull = true;
    protected List<DataSetOperation> beforeTestOperations = new ArrayList<DataSetOperation>();
    protected List<DataSetOperation> afterTestOperations = new ArrayList<DataSetOperation>();
    private boolean prepared = false;

    @BeforeClass
    @Parameters(value={"datasourceJndiName"})
    public void setDatasourceJndiName(@Optional String datasourceJndiName) {
        if (datasourceJndiName == null) {
            return;
        }
        this.log.debug("Setting datasource name: " + datasourceJndiName);
        this.datasourceJndiName = datasourceJndiName;
    }

    public String getDatasourceJndiName() {
        return this.datasourceJndiName;
    }

    @BeforeClass
    @Parameters(value={"binaryDir"})
    public void setBinaryDir(@Optional String binaryDir) {
        if (binaryDir == null) {
            return;
        }
        this.log.debug("Setting binary directory: " + binaryDir);
        this.binaryDir = binaryDir;
    }

    public String getBinaryDir() {
        return this.binaryDir;
    }

    @BeforeClass
    @Parameters(value={"database"})
    public void setDatabase(@Optional String database) {
        if (database == null) {
            return;
        }
        this.log.debug("Setting database: " + database);
        this.database = Database.valueOf(database.toUpperCase());
    }

    @BeforeClass
    @Parameters(value={"replaceNull"})
    public void setReplaceNull(@Optional Boolean replaceNull) {
        if (replaceNull == null) {
            return;
        }
        this.log.debug("Setting replace null: " + replaceNull);
        this.replaceNull = replaceNull;
    }

    public Boolean isReplaceNull() {
        return this.replaceNull;
    }

    @BeforeMethod
    public void prepareDataBeforeTest() {
        if (!this.prepared) {
            this.log.debug("Before test method runs, preparing datasets");
            this.prepareDBUnitOperations();
            for (DataSetOperation beforeTestOperation : this.beforeTestOperations) {
                beforeTestOperation.prepare(this);
            }
            for (DataSetOperation afterTestOperation : this.afterTestOperations) {
                afterTestOperation.prepare(this);
            }
            this.prepared = true;
        }
        this.executeOperations(this.beforeTestOperations);
    }

    @AfterMethod
    public void cleanDataAfterTest() {
        this.executeOperations(this.afterTestOperations);
    }

    private void executeOperations(List<DataSetOperation> list) {
        this.log.debug("Executing DataSetOperations: " + list.size());
        IDatabaseConnection con = null;
        try {
            con = this.getConnection();
            this.disableReferentialIntegrity(con);
            for (DataSetOperation op : list) {
                this.prepareExecution(con, op);
                op.execute(con);
                this.afterExecution(con, op);
            }
            this.enableReferentialIntegrity(con);
        }
        finally {
            if (con != null) {
                try {
                    con.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace(System.err);
                }
            }
        }
    }

    protected IDatabaseConnection getConnection() {
        try {
            if (this.getDatasourceJndiName() == null) {
                throw new RuntimeException("Please set datasourceJndiName TestNG property");
            }
            DataSource datasource = (DataSource)this.getInitialContext().lookup(this.getDatasourceJndiName());
            Connection con = datasource.getConnection();
            DatabaseConnection dbUnitCon = new DatabaseConnection(con);
            this.editConfig(dbUnitCon.getConfig());
            return dbUnitCon;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void disableReferentialIntegrity(IDatabaseConnection con) {
        try {
            if (this.database.equals((Object)Database.HSQL)) {
                con.getConnection().prepareStatement("set referential_integrity FALSE").execute();
            } else if (this.database.equals((Object)Database.MYSQL)) {
                con.getConnection().prepareStatement("set foreign_key_checks=0").execute();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void enableReferentialIntegrity(IDatabaseConnection con) {
        try {
            if (this.database.equals((Object)Database.HSQL)) {
                con.getConnection().prepareStatement("set referential_integrity TRUE").execute();
            } else if (this.database.equals((Object)Database.MYSQL)) {
                con.getConnection().prepareStatement("set foreign_key_checks=1").execute();
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void editConfig(DatabaseConfig config) {
        if (this.database.equals((Object)Database.HSQL)) {
            config.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new DefaultDataTypeFactory(){

                public DataType createDataType(int sqlType, String sqlTypeName) throws DataTypeException {
                    if (sqlType == 16) {
                        return DataType.BOOLEAN;
                    }
                    return super.createDataType(sqlType, sqlTypeName);
                }
            });
        }
    }

    protected void prepareExecution(IDatabaseConnection con, DataSetOperation operation) {
    }

    protected void afterExecution(IDatabaseConnection con, DataSetOperation operation) {
    }

    protected URL getBinaryDirFullpath() {
        if (this.getBinaryDir() == null) {
            throw new RuntimeException("Please set binaryDir TestNG property to location of binary test files");
        }
        return this.getResourceURL(this.getBinaryDir());
    }

    protected URL getResourceURL(String resource) {
        URL url = Thread.currentThread().getContextClassLoader().getResource(resource);
        if (url == null) {
            throw new RuntimeException("Could not find resource with classloader: " + resource);
        }
        return url;
    }

    protected byte[] getBinaryFile(String filename) throws Exception {
        int numRead;
        if (this.getBinaryDir() == null) {
            throw new RuntimeException("Please set binaryDir TestNG property to location of binary test files");
        }
        File file = new File(this.getResourceURL(String.valueOf(this.getBinaryDir()) + "/" + filename).toURI());
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    protected abstract void prepareDBUnitOperations();

    protected static class DataSetOperation {
        private LogProvider log = Logging.getLogProvider(DataSetOperation.class);
        String dataSetLocation;
        ReplacementDataSet dataSet;
        DatabaseOperation operation;

        protected DataSetOperation() {
        }

        public DataSetOperation(String dataSetLocation) {
            this(dataSetLocation, DatabaseOperation.CLEAN_INSERT);
        }

        public DataSetOperation(String dataSetLocation, String dtdLocation) {
            this(dataSetLocation, dtdLocation, DatabaseOperation.CLEAN_INSERT);
        }

        public DataSetOperation(String dataSetLocation, DatabaseOperation operation) {
            this(dataSetLocation, null, operation);
        }

        public DataSetOperation(String dataSetLocation, String dtdLocation, DatabaseOperation operation) {
            if (dataSetLocation == null) {
                this.operation = operation;
                return;
            }
            InputStream input = Thread.currentThread().getContextClassLoader().getResourceAsStream(dataSetLocation);
            try {
                InputStream dtdInput = null;
                if (dtdLocation != null) {
                    dtdInput = Thread.currentThread().getContextClassLoader().getResourceAsStream(dtdLocation);
                }
                this.dataSet = dtdInput == null ? new ReplacementDataSet((IDataSet)new FlatXmlDataSet(input)) : new ReplacementDataSet((IDataSet)new FlatXmlDataSet(input, dtdInput));
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            this.operation = operation;
            this.dataSetLocation = dataSetLocation;
        }

        public IDataSet getDataSet() {
            return this.dataSet;
        }

        public DatabaseOperation getOperation() {
            return this.operation;
        }

        public void prepare(DBUnitSeamTest test) {
            if (this.dataSet == null) {
                return;
            }
            this.log.debug("Preparing DataSetOperation replacement values");
            if (test.isReplaceNull().booleanValue()) {
                this.log.debug("Replacing [NULL] placeholder with real null value");
                this.dataSet.addReplacementObject((Object)"[NULL]", null);
            }
            if (test.getBinaryDir() != null) {
                this.log.debug("Replacing [BINARY_DIR] placeholder with path: " + test.getBinaryDirFullpath().toString());
                this.dataSet.addReplacementSubstring("[BINARY_DIR]", test.getBinaryDirFullpath().toString());
            }
        }

        public void execute(IDatabaseConnection connection) {
            if (this.dataSet == null || this.operation == null) {
                return;
            }
            try {
                this.log.debug("Executing: " + this);
                this.operation.execute(connection, (IDataSet)this.dataSet);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + " with dataset location: " + this.dataSetLocation;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Database {
        HSQL,
        MYSQL;

    }
}

