/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.intercept;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.jboss.seam.Component;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.InterceptorType;
import org.jboss.seam.annotations.intercept.PostActivate;
import org.jboss.seam.annotations.intercept.PostConstruct;
import org.jboss.seam.annotations.intercept.PrePassivate;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.intercept.OptimizedInterceptor;
import org.jboss.seam.util.EJB;
import org.jboss.seam.util.Reflections;

public final class Interceptor
extends Reflections {
    private Class<?> userInterceptorClass;
    private Object statelessUserInterceptorInstance;
    private Method aroundInvokeMethod;
    private Method postConstructMethod;
    private Method preDestroyMethod;
    private Method postActivateMethod;
    private Method prePassivateMethod;
    private Method componentInjectorMethod;
    private Method annotationInjectorMethod;
    private Method interceptorEnabledMethod;
    private InterceptorType type;
    private Annotation annotation;
    private Component component;
    private boolean optimized;

    private boolean isStateless() {
        return this.userInterceptorClass.isAnnotationPresent(org.jboss.seam.annotations.intercept.Interceptor.class) && this.userInterceptorClass.getAnnotation(org.jboss.seam.annotations.intercept.Interceptor.class).stateless();
    }

    public Object createUserInterceptor() {
        if (this.isStateless()) {
            return this.statelessUserInterceptorInstance;
        }
        try {
            Object userInterceptor = this.userInterceptorClass.newInstance();
            if (this.componentInjectorMethod != null) {
                Reflections.invokeAndWrap(this.componentInjectorMethod, userInterceptor, this.component);
            }
            if (this.annotationInjectorMethod != null) {
                Reflections.invokeAndWrap(this.annotationInjectorMethod, userInterceptor, this.annotation);
            }
            return userInterceptor;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class getUserInterceptorClass() {
        return this.userInterceptorClass;
    }

    public InterceptorType getType() {
        return this.type;
    }

    public String toString() {
        return "Interceptor(" + this.userInterceptorClass.getName() + ")";
    }

    public Interceptor(Object interceptor, Component component) {
        this.userInterceptorClass = interceptor.getClass();
        this.statelessUserInterceptorInstance = interceptor;
        this.component = component;
        this.init();
    }

    public Interceptor(Class[] classes, Annotation annotation, Component component) {
        if (classes.length != 1) {
            throw new IllegalArgumentException("Must be exactly one interceptor when used as a meta-annotation");
        }
        this.userInterceptorClass = classes[0];
        try {
            this.statelessUserInterceptorInstance = this.userInterceptorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("could not instantiate interceptor", e);
        }
        this.annotation = annotation;
        this.component = component;
        this.init();
    }

    private void init() {
        Method[] methodArray = this.userInterceptorClass.getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            if (method.isAnnotationPresent(EJB.AROUND_INVOKE) || method.isAnnotationPresent(AroundInvoke.class)) {
                this.aroundInvokeMethod = method;
            }
            if (method.isAnnotationPresent(EJB.POST_CONSTRUCT) || method.isAnnotationPresent(PostConstruct.class)) {
                this.postConstructMethod = method;
            }
            if (method.isAnnotationPresent(EJB.PRE_DESTROY)) {
                this.preDestroyMethod = method;
            }
            if (method.isAnnotationPresent(EJB.PRE_PASSIVATE) || method.isAnnotationPresent(PrePassivate.class)) {
                this.prePassivateMethod = method;
            }
            if (method.isAnnotationPresent(EJB.POST_ACTIVATE) || method.isAnnotationPresent(PostActivate.class)) {
                this.postActivateMethod = method;
            }
            Class<?>[] params = method.getParameterTypes();
            if (this.annotation != null && params.length == 1 && params[0] == this.annotation.annotationType()) {
                this.annotationInjectorMethod = method;
                Reflections.invokeAndWrap(method, this.statelessUserInterceptorInstance, this.annotation);
            }
            if (params.length == 1 && params[0] == Component.class) {
                this.componentInjectorMethod = method;
                Reflections.invokeAndWrap(method, this.statelessUserInterceptorInstance, this.component);
            }
            if ("isInterceptorEnabled".equals(method.getName()) && method.getReturnType().equals(Boolean.TYPE)) {
                this.interceptorEnabledMethod = method;
            }
            ++n2;
        }
        this.type = this.userInterceptorClass.isAnnotationPresent(org.jboss.seam.annotations.intercept.Interceptor.class) ? this.userInterceptorClass.getAnnotation(org.jboss.seam.annotations.intercept.Interceptor.class).type() : InterceptorType.SERVER;
        this.optimized = OptimizedInterceptor.class.isAssignableFrom(this.userInterceptorClass);
    }

    public boolean isOptimized() {
        return this.optimized;
    }

    public Object aroundInvoke(InvocationContext invocation, Object userInterceptor) throws Exception {
        return this.aroundInvokeMethod == null ? invocation.proceed() : Reflections.invoke(this.aroundInvokeMethod, userInterceptor, invocation);
    }

    public Object postConstruct(InvocationContext invocation, Object userInterceptor) throws Exception {
        return this.postConstructMethod == null ? invocation.proceed() : Reflections.invoke(this.postConstructMethod, userInterceptor, invocation);
    }

    public Object preDestroy(InvocationContext invocation, Object userInterceptor) throws Exception {
        return this.preDestroyMethod == null ? invocation.proceed() : Reflections.invoke(this.preDestroyMethod, userInterceptor, invocation);
    }

    public Object prePassivate(InvocationContext invocation, Object userInterceptor) throws Exception {
        return this.prePassivateMethod == null ? invocation.proceed() : Reflections.invoke(this.prePassivateMethod, userInterceptor, invocation);
    }

    public Object postActivate(InvocationContext invocation, Object userInterceptor) throws Exception {
        return this.postActivateMethod == null ? invocation.proceed() : Reflections.invoke(this.postActivateMethod, userInterceptor, invocation);
    }

    public boolean isInterceptorEnabled() {
        if (this.interceptorEnabledMethod != null) {
            if (this.componentInjectorMethod != null) {
                Reflections.invokeAndWrap(this.componentInjectorMethod, this.statelessUserInterceptorInstance, this.component);
            }
            if (this.annotationInjectorMethod != null) {
                Reflections.invokeAndWrap(this.annotationInjectorMethod, this.statelessUserInterceptorInstance, this.annotation);
            }
            if (this.isOptimized()) {
                return ((OptimizedInterceptor)this.statelessUserInterceptorInstance).isInterceptorEnabled();
            }
            return (Boolean)Reflections.invokeAndWrap(this.interceptorEnabledMethod, this.statelessUserInterceptorInstance, new Object[0]);
        }
        return true;
    }
}

