/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jboss.seam.util.EnumerationEnumeration;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamDeploymentProperties {
    private ClassLoader classLoader;
    private Enumeration<URL> urlEnum;
    public static final String RESOURCE_BUNDLE = "META-INF/seam-deployment.properties";
    private static final String[] RESOURCE_BUNDLES = new String[]{"META-INF/seam-deployment.properties", "META-INF/seam-scanner.properties"};

    public SeamDeploymentProperties(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<String> getPropertyValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    private void addPropertiesFromSystem(String key, List<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    private void addPropertiesFromResourceBundle(String key, List<String> values) {
        try {
            while (this.getResources().hasMoreElements()) {
                URL url = this.getResources().nextElement();
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream != null) {
                        propertyStream.close();
                    }
                }
            }
        }
        catch (IOException iOException) {}
    }

    private void addProperty(String key, String value, List<String> values) {
        if (value != null) {
            String[] properties;
            String[] stringArray = properties = Strings.split(value, ":");
            int n = properties.length;
            int n2 = 0;
            while (n2 < n) {
                String property = stringArray[n2];
                values.add(property);
                ++n2;
            }
        }
    }

    private Enumeration<URL> getResources() throws IOException {
        if (this.urlEnum == null) {
            Enumeration[] enumerations = new Enumeration[RESOURCE_BUNDLES.length];
            int i = 0;
            while (i < RESOURCE_BUNDLES.length) {
                enumerations[i] = this.classLoader.getResources(RESOURCE_BUNDLES[i]);
                ++i;
            }
            this.urlEnum = new EnumerationEnumeration<URL>(enumerations);
        }
        return this.urlEnum;
    }
}

