/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.ResourceLoader;
import org.jboss.seam.el.EL;
import org.jboss.seam.el.SeamExpressionFactory;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@BypassInterceptors
@Install(precedence=0)
@Name(value="org.jboss.seam.core.expressions")
public class Expressions
implements Serializable {
    private static final LogProvider log;
    private static List<String> blacklist;
    static final String WHITESPACE_REGEX_STRING = "\\s";
    static final Pattern WHITESPACE_REGEX_PATTERN;

    static {
        block15: {
            log = Logging.getLogProvider(Expressions.class);
            blacklist = new ArrayList<String>();
            BufferedReader reader = null;
            try {
                try {
                    String line;
                    InputStream blacklistIS = ResourceLoader.instance().getResourceAsStream("blacklist.properties");
                    reader = new BufferedReader(new InputStreamReader(blacklistIS));
                    while ((line = reader.readLine()) != null) {
                        blacklist.add(line);
                    }
                }
                catch (IOException iOException) {
                    log.warn("Black list of non-valid EL expressions was not found!");
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        WHITESPACE_REGEX_PATTERN = Pattern.compile(WHITESPACE_REGEX_STRING);
    }

    public ExpressionFactory getExpressionFactory() {
        return SeamExpressionFactory.INSTANCE;
    }

    public ELContext getELContext() {
        return EL.createELContext();
    }

    public ValueExpression<Object> createValueExpression(String expression) {
        return this.createValueExpression(expression, Object.class);
    }

    public MethodExpression<Object> createMethodExpression(String expression) {
        return this.createMethodExpression(expression, Object.class, new Class[0]);
    }

    public <T> ValueExpression<T> createValueExpression(final String expression, final Class<T> type) {
        Expressions.checkELExpression(expression);
        return new ValueExpression<T>(){
            private javax.el.ValueExpression facesValueExpression;
            private javax.el.ValueExpression seamValueExpression;

            @Override
            public javax.el.ValueExpression toUnifiedValueExpression() {
                if (Expressions.this.isFacesContextActive()) {
                    if (this.facesValueExpression == null) {
                        this.facesValueExpression = this.createExpression();
                    }
                    return this.facesValueExpression;
                }
                if (this.seamValueExpression == null) {
                    this.seamValueExpression = this.createExpression();
                }
                return this.seamValueExpression;
            }

            private javax.el.ValueExpression createExpression() {
                return Expressions.this.getExpressionFactory().createValueExpression(Expressions.this.getELContext(), expression, type);
            }

            @Override
            public T getValue() {
                return this.toUnifiedValueExpression().getValue(Expressions.this.getELContext());
            }

            @Override
            public void setValue(T value) {
                this.toUnifiedValueExpression().setValue(Expressions.this.getELContext(), value);
            }

            @Override
            public String getExpressionString() {
                return expression;
            }

            @Override
            public Class<T> getType() {
                return this.toUnifiedValueExpression().getType(Expressions.this.getELContext());
            }
        };
    }

    public <T> MethodExpression<T> createMethodExpression(final String expression, final Class<T> type, final Class ... argTypes) {
        Expressions.checkELExpression(expression);
        return new MethodExpression<T>(){
            private javax.el.MethodExpression facesMethodExpression;
            private javax.el.MethodExpression seamMethodExpression;

            @Override
            public javax.el.MethodExpression toUnifiedMethodExpression() {
                if (Expressions.this.isFacesContextActive()) {
                    if (this.facesMethodExpression == null) {
                        this.facesMethodExpression = this.createExpression();
                    }
                    return this.facesMethodExpression;
                }
                if (this.seamMethodExpression == null) {
                    this.seamMethodExpression = this.createExpression();
                }
                return this.seamMethodExpression;
            }

            private javax.el.MethodExpression createExpression() {
                return Expressions.this.getExpressionFactory().createMethodExpression(Expressions.this.getELContext(), expression, type, argTypes);
            }

            @Override
            public T invoke(Object ... args) {
                return this.toUnifiedMethodExpression().invoke(Expressions.this.getELContext(), args);
            }

            @Override
            public String getExpressionString() {
                return expression;
            }
        };
    }

    protected boolean isFacesContextActive() {
        return false;
    }

    public static Expressions instance() {
        if (!Contexts.isApplicationContextActive()) {
            return new Expressions();
        }
        return (Expressions)Component.getInstance(Expressions.class, ScopeType.APPLICATION);
    }

    private static void checkELExpression(String expression) {
        if (expression == null) {
            return;
        }
        String expressionTrimmed = WHITESPACE_REGEX_PATTERN.matcher(expression).replaceAll("");
        int index = 0;
        while (blacklist.size() > index) {
            if (expressionTrimmed.contains(blacklist.get(index))) {
                throw new IllegalArgumentException("This EL expression is not allowed!");
            }
            ++index;
        }
        if (expressionTrimmed.contains(".getClass(") || expressionTrimmed.contains(".class.")) {
            throw new IllegalArgumentException("This EL expression is not allowed!");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MethodExpression<T>
    extends Serializable {
        public T invoke(Object ... var1);

        public String getExpressionString();

        public javax.el.MethodExpression toUnifiedMethodExpression();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface ValueExpression<T>
    extends Serializable {
        public T getValue();

        public void setValue(T var1);

        public String getExpressionString();

        public Class<T> getType();

        public javax.el.ValueExpression toUnifiedValueExpression();
    }
}

