/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.core;

import java.lang.reflect.Method;
import java.util.Arrays;
import org.jboss.seam.annotations.ApplicationException;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.FlushModeType;
import org.jboss.seam.annotations.bpm.BeginTask;
import org.jboss.seam.annotations.bpm.EndTask;
import org.jboss.seam.annotations.bpm.StartTask;
import org.jboss.seam.annotations.intercept.AroundInvoke;
import org.jboss.seam.annotations.intercept.Interceptor;
import org.jboss.seam.bpm.BusinessProcessInterceptor;
import org.jboss.seam.core.BijectionInterceptor;
import org.jboss.seam.core.ConversationEntries;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.ConversationPropagation;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Interpolator;
import org.jboss.seam.core.Manager;
import org.jboss.seam.intercept.AbstractInterceptor;
import org.jboss.seam.intercept.InvocationContext;
import org.jboss.seam.navigation.ConversationIdParameter;
import org.jboss.seam.navigation.Pages;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.persistence.PersistenceContexts;

@Interceptor(stateless=true, around={BijectionInterceptor.class}, within={BusinessProcessInterceptor.class})
public class ConversationInterceptor
extends AbstractInterceptor {
    private static final long serialVersionUID = -5405533438107796414L;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @AroundInvoke
    public Object aroundInvoke(InvocationContext invocation) throws Exception {
        Method method;
        block4: {
            try {
                method = invocation.getMethod();
                if (!this.getComponent().isConversationManagementMethod(method)) return invocation.proceed();
                if (this.isMissingJoin(method)) {
                    throw new IllegalStateException("begin method invoked from a long-running conversation, try using @Begin(join=true) on method: " + method.getName());
                }
                if (!this.redirectToExistingConversation(method)) break block4;
                return null;
            }
            catch (Exception e) {
                if (!this.isEndConversationRequired(e)) throw e;
                this.endConversation(false, false);
                throw e;
            }
        }
        Object result = invocation.proceed();
        this.beginConversationIfNecessary(method, result);
        this.endConversationIfNecessary(method, result);
        return result;
    }

    private boolean isEndConversationRequired(Exception e) {
        Class<?> clazz = e.getClass();
        return clazz.isAnnotationPresent(ApplicationException.class) && clazz.getAnnotation(ApplicationException.class).end();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean redirectToExistingConversation(Method method) {
        String conversation;
        if (Manager.instance().isLongRunningConversation()) return false;
        String id = null;
        ConversationPropagation propagation = ConversationPropagation.instance();
        String string = conversation = propagation != null ? propagation.getConversationName() : null;
        if (method.isAnnotationPresent(Begin.class)) {
            id = method.getAnnotation(Begin.class).id();
        } else if (method.isAnnotationPresent(BeginTask.class)) {
            id = method.getAnnotation(BeginTask.class).id();
        } else if (method.isAnnotationPresent(StartTask.class)) {
            id = method.getAnnotation(StartTask.class).id();
        }
        if (id != null && !"".equals(id)) {
            id = Interpolator.instance().interpolate(id, new Object[0]);
            ConversationEntry ce = ConversationEntries.instance().getConversationEntry(id);
            if (ce != null) return ce.redirect();
            Manager.instance().updateCurrentConversationId(id);
            return false;
        } else {
            ConversationEntry ce;
            ConversationIdParameter param;
            if (conversation == null || "".equals(conversation) || (param = Pages.instance().getConversationIdParameter(conversation)) == null || (ce = ConversationEntries.instance().getConversationEntry(param.getConversationId())) == null) return false;
            return ce.redirect();
        }
    }

    private boolean isMissingJoin(Method method) {
        return Manager.instance().isLongRunningOrNestedConversation() && (method.isAnnotationPresent(Begin.class) && !method.getAnnotation(Begin.class).join() && !method.getAnnotation(Begin.class).nested() || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(StartTask.class));
    }

    private void beginConversationIfNecessary(Method method, Object result) {
        String[] outcomes;
        boolean simpleBegin;
        boolean bl = simpleBegin = method.isAnnotationPresent(StartTask.class) || method.isAnnotationPresent(BeginTask.class) || method.isAnnotationPresent(Begin.class) && method.getAnnotation(Begin.class).ifOutcome().length == 0;
        if (simpleBegin) {
            if (result != null || method.getReturnType().equals(Void.TYPE)) {
                boolean nested = false;
                if (method.isAnnotationPresent(Begin.class)) {
                    nested = method.getAnnotation(Begin.class).nested();
                }
                this.beginConversation(nested, this.getProcessDefinitionName(method));
                this.setFlushMode(method);
            }
        } else if (method.isAnnotationPresent(Begin.class) && ((outcomes = method.getAnnotation(Begin.class).ifOutcome()).length == 0 || Arrays.asList(outcomes).contains(result))) {
            this.beginConversation(method.getAnnotation(Begin.class).nested(), this.getProcessDefinitionName(method));
            this.setFlushMode(method);
        }
    }

    private void setFlushMode(Method method) {
        FlushModeType flushMode;
        if (method.isAnnotationPresent(Begin.class)) {
            flushMode = method.getAnnotation(Begin.class).flushMode();
        } else if (method.isAnnotationPresent(BeginTask.class)) {
            flushMode = method.getAnnotation(BeginTask.class).flushMode();
        } else if (method.isAnnotationPresent(StartTask.class)) {
            flushMode = method.getAnnotation(StartTask.class).flushMode();
        } else {
            return;
        }
        PersistenceContexts.instance().changeFlushMode(flushMode);
    }

    private String getProcessDefinitionName(Method method) {
        if (method.isAnnotationPresent(Begin.class)) {
            return method.getAnnotation(Begin.class).pageflow();
        }
        if (method.isAnnotationPresent(BeginTask.class)) {
            return method.getAnnotation(BeginTask.class).pageflow();
        }
        if (method.isAnnotationPresent(StartTask.class)) {
            return method.getAnnotation(StartTask.class).pageflow();
        }
        return "";
    }

    private void beginConversation(boolean nested, String pageflowName) {
        if (!Manager.instance().isLongRunningOrNestedConversation()) {
            Manager.instance().beginConversation();
            this.beginNavigation(pageflowName);
        } else if (nested) {
            Manager.instance().beginNestedConversation();
            this.beginNavigation(pageflowName);
        }
    }

    private void beginNavigation(String pageflowName) {
        if (!pageflowName.equals("")) {
            if (!Init.instance().isJbpmInstalled()) {
                throw new IllegalArgumentException("attempting to begin pageflow but required org.jboss.seam.bpm.jbpm component is not installed");
            }
            Pageflow.instance().begin(pageflowName);
        }
    }

    private void endConversationIfNecessary(Method method, Object result) {
        String[] outcomes;
        boolean simpleEnd;
        boolean isEndAnnotation = method.isAnnotationPresent(End.class);
        boolean isEndTaskAnnotation = method.isAnnotationPresent(EndTask.class);
        boolean beforeRedirect = isEndAnnotation && method.getAnnotation(End.class).beforeRedirect() || isEndTaskAnnotation && method.getAnnotation(EndTask.class).beforeRedirect();
        boolean endRoot = isEndAnnotation && method.getAnnotation(End.class).root();
        boolean bl = simpleEnd = isEndAnnotation && method.getAnnotation(End.class).ifOutcome().length == 0 || isEndTaskAnnotation && method.getAnnotation(EndTask.class).ifOutcome().length == 0;
        if (simpleEnd) {
            if (result != null || method.getReturnType().equals(Void.TYPE)) {
                this.endConversation(beforeRedirect, endRoot);
            }
        } else if (isEndAnnotation) {
            String[] outcomes2 = method.getAnnotation(End.class).ifOutcome();
            if (Arrays.asList(outcomes2).contains(result)) {
                this.endConversation(beforeRedirect, endRoot);
            }
        } else if (isEndTaskAnnotation && Arrays.asList(outcomes = method.getAnnotation(EndTask.class).ifOutcome()).contains(result)) {
            this.endConversation(beforeRedirect, endRoot);
        }
    }

    private void endConversation(boolean beforeRedirect, boolean endRoot) {
        if (endRoot) {
            Manager.instance().endRootConversation(beforeRedirect);
        } else {
            Manager.instance().endConversation(beforeRedirect);
        }
    }

    public boolean isInterceptorEnabled() {
        return this.getComponent().hasConversationManagementMethods();
    }
}

