/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.el.CompositeELResolver;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.PropertyNotFoundException;
import javax.el.ValueExpression;
import org.jboss.seam.bpm.JbpmELResolver;
import org.jboss.seam.el.EL;
import org.jboss.seam.el.SeamFunctionMapper;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jbpm.jpdl.el.ELException;
import org.jbpm.jpdl.el.Expression;
import org.jbpm.jpdl.el.ExpressionEvaluator;
import org.jbpm.jpdl.el.FunctionMapper;
import org.jbpm.jpdl.el.VariableResolver;

public class SeamExpressionEvaluator
extends ExpressionEvaluator {
    private static LogProvider log = Logging.getLogProvider(SeamExpressionEvaluator.class);

    public Object evaluate(String expression, Class returnType, VariableResolver resolver, FunctionMapper mapper) throws ELException {
        return SeamExpressionEvaluator.createExpression(expression, returnType, mapper).evaluate(resolver);
    }

    public Expression parseExpression(String expression, Class returnType, FunctionMapper mapper) throws ELException {
        return SeamExpressionEvaluator.createExpression(expression, returnType, mapper);
    }

    private static Expression createExpression(final String expression, final Class returnType, final FunctionMapper mapper) {
        return new Expression(){
            private ELContext elContext = EL.createELContext();
            private MethodExpression me;
            private ValueExpression ve;

            private void initMethodExpression() {
                if (this.me == null || this.ve == null) {
                    this.me = EL.EXPRESSION_FACTORY.createMethodExpression(this.elContext, expression, returnType, new Class[0]);
                }
            }

            private void initValueExpression() {
                if (this.me == null || this.ve == null) {
                    this.ve = EL.EXPRESSION_FACTORY.createValueExpression(this.elContext, expression, returnType);
                }
            }

            public Object evaluate(VariableResolver resolver) throws ELException {
                ArrayList<Throwable> exceptions = new ArrayList<Throwable>();
                try {
                    this.initMethodExpression();
                    if (this.me != null) {
                        try {
                            return this.me.invoke(SeamExpressionEvaluator.createELContext(resolver, mapper), new Object[0]);
                        }
                        catch (MethodNotFoundException methodNotFoundException) {
                            exceptions.add(methodNotFoundException);
                        }
                    }
                }
                catch (javax.el.ELException eLException) {
                    exceptions.add(eLException);
                }
                try {
                    this.initValueExpression();
                    if (this.ve != null) {
                        try {
                            return this.ve.getValue(SeamExpressionEvaluator.createELContext(resolver, mapper));
                        }
                        catch (PropertyNotFoundException propertyNotFoundException) {
                            exceptions.add(propertyNotFoundException);
                        }
                    }
                }
                catch (javax.el.ELException eLException) {
                    exceptions.add(eLException);
                }
                if (exceptions.size() == 1) {
                    throw new ELException("Error evaluating " + expression, (Throwable)exceptions.get(0));
                }
                if (exceptions.size() > 1) {
                    log.debug("Exceptions occurred when parsing " + expression);
                    for (javax.el.ELException eLException : exceptions) {
                        log.debug("Possible cause", eLException);
                    }
                }
                if (this.me == null && this.ve == null) {
                    log.debug("Error parsing " + expression);
                    throw new ELException("Error parsing " + expression + "; not a valid EL expression");
                }
                throw new ELException("Error evaluating " + expression + "; possible causes are logged at debug level");
            }
        };
    }

    private static javax.el.FunctionMapper decorateFunctionMapper(final FunctionMapper functionMapper) {
        return new SeamFunctionMapper(new javax.el.FunctionMapper(){

            public Method resolveFunction(String prefix, String localName) {
                return functionMapper.resolveFunction(prefix, localName);
            }
        });
    }

    private static ELContext createELContext(VariableResolver resolver, FunctionMapper functionMapper) {
        CompositeELResolver composite = new CompositeELResolver();
        composite.add(EL.EL_RESOLVER);
        composite.add((ELResolver)new JbpmELResolver(resolver));
        return EL.createELContext((ELResolver)composite, SeamExpressionEvaluator.decorateFunctionMapper(functionMapper));
    }
}

