/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.bpm;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jboss.seam.deployment.AbstractDeploymentHandler;
import org.jboss.seam.deployment.DeploymentMetadata;
import org.jboss.seam.deployment.FileDescriptor;
import org.jboss.seam.log.LogProvider;
import org.jboss.seam.log.Logging;
import org.jboss.seam.util.Resources;
import org.jboss.seam.util.XML;

public class PageflowDeploymentHandler
extends AbstractDeploymentHandler {
    private static DeploymentMetadata NAMESPACE_METADATA = new DeploymentMetadata(){

        public String getFileNameSuffix() {
            return ".jpdl.xml";
        }
    };
    private static LogProvider log = Logging.getLogProvider(PageflowDeploymentHandler.class);
    public static final String NAME = "org.jboss.seam.bpm.PageflowDeploymentHandler";

    public String getName() {
        return NAME;
    }

    public void postProcess(ClassLoader classLoader) {
        HashSet<FileDescriptor> files = new HashSet<FileDescriptor>();
        for (FileDescriptor fileDescriptor : this.getResources()) {
            try {
                InputStream inputStream = fileDescriptor.getUrl().openStream();
                try {
                    try {
                        Element root = XML.getRootElementSafely(inputStream);
                        if ("pageflow-definition".equals(root.getName())) {
                            files.add(fileDescriptor);
                        }
                    }
                    catch (DocumentException e) {
                        log.debug("Unable to parse " + fileDescriptor.getName(), e);
                        Resources.closeStream(inputStream);
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    Resources.closeStream(inputStream);
                    throw throwable;
                }
                Resources.closeStream(inputStream);
            }
            catch (IOException iOException) {
                log.trace("Error loading " + fileDescriptor.getName());
            }
        }
        this.setResources(files);
    }

    public DeploymentMetadata getMetadata() {
        return NAMESPACE_METADATA;
    }
}

