/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.persistence.EmbeddedId;
import javax.persistence.Id;
import javax.persistence.PostLoad;
import javax.persistence.PrePersist;
import javax.persistence.PreRemove;
import javax.persistence.PreUpdate;
import javax.persistence.Version;
import org.jboss.seam.Model;
import org.jboss.seam.Seam;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.init.EjbDescriptor;
import org.jboss.seam.init.EjbEntityDescriptor;
import org.jboss.seam.util.Reflections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Entity
extends Model {
    private Method preRemoveMethod;
    private Method prePersistMethod;
    private Method preUpdateMethod;
    private Method postLoadMethod;
    private Method identifierGetter;
    private Field identifierField;
    private Method versionGetter;
    private Field versionField;
    private String name;

    @Deprecated
    public Entity(Class<?> beanClass) {
        super(beanClass);
        EjbDescriptor descriptor = Seam.getEjbDescriptor(beanClass);
        if (descriptor instanceof EjbEntityDescriptor) {
            this.mergeAnnotationAndOrmXml((EjbEntityDescriptor)descriptor);
        } else {
            this.mergeAnnotationAndOrmXml(null);
        }
    }

    public Method getPostLoadMethod() {
        return this.postLoadMethod;
    }

    public Method getPrePersistMethod() {
        return this.prePersistMethod;
    }

    public Method getPreRemoveMethod() {
        return this.preRemoveMethod;
    }

    public Method getPreUpdateMethod() {
        return this.preUpdateMethod;
    }

    @Deprecated
    public Field getIdentifierField() {
        return this.identifierField;
    }

    @Deprecated
    public Method getIdentifierGetter() {
        return this.identifierGetter;
    }

    @Deprecated
    public Field getVersionField() {
        return this.versionField;
    }

    @Deprecated
    public Method getVersionGetter() {
        return this.versionGetter;
    }

    public Object getIdentifier(Object entity) {
        if (this.identifierGetter != null) {
            return Reflections.invokeAndWrap(this.identifierGetter, entity, new Object[0]);
        }
        if (this.identifierField != null) {
            return Reflections.getAndWrap(this.identifierField, entity);
        }
        throw new IllegalStateException("@Id attribute not found for entity class: " + this.getBeanClass().getName());
    }

    public Object getVersion(Object entity) {
        if (this.versionGetter != null) {
            return Reflections.invokeAndWrap(this.versionGetter, entity, new Object[0]);
        }
        if (this.versionField != null) {
            return Reflections.getAndWrap(this.versionField, entity);
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public static Entity forBean(Object bean) {
        return Entity.forClass(bean.getClass());
    }

    public static Entity forClass(Class clazz) {
        if (!Contexts.isApplicationContextActive()) {
            throw new IllegalStateException("No application context active");
        }
        Class entityClass = Seam.getEntityClass(clazz);
        if (entityClass == null) {
            throw new NotEntityException("Not an entity class: " + clazz.getName());
        }
        String name = Entity.getModelName(entityClass);
        Model model = (Model)Contexts.getApplicationContext().get(name);
        if (model == null || !(model instanceof Entity)) {
            Entity entity = new Entity(entityClass);
            Contexts.getApplicationContext().set(name, entity);
            return entity;
        }
        return (Entity)model;
    }

    private void mergeAnnotationAndOrmXml(EjbEntityDescriptor descriptor) {
        this.name = Entity.lookupName(this.getBeanClass(), descriptor);
        if (this.name == null) {
            throw new NotEntityException("Unable to establish name of entity " + this.getBeanClass());
        }
        if (descriptor != null) {
            this.preRemoveMethod = Entity.getEntityCallbackMethod(this.getBeanClass(), descriptor.getPreRemoveMethodName());
            this.prePersistMethod = Entity.getEntityCallbackMethod(this.getBeanClass(), descriptor.getPrePersistMethodName());
            this.preUpdateMethod = Entity.getEntityCallbackMethod(this.getBeanClass(), descriptor.getPreUpdateMethodName());
            this.postLoadMethod = Entity.getEntityCallbackMethod(this.getBeanClass(), descriptor.getPostLoadMethodName());
            this.identifierField = descriptor.getIdentifierFieldName() != null ? Reflections.getField(this.getBeanClass(), descriptor.getIdentifierFieldName()) : null;
            this.identifierGetter = descriptor.getIdentifierPropertyName() != null ? Reflections.getGetterMethod(this.getBeanClass(), descriptor.getIdentifierPropertyName()) : null;
            this.versionField = descriptor.getVersionFieldName() != null ? Reflections.getField(this.getBeanClass(), descriptor.getVersionFieldName()) : null;
            Method method = this.versionGetter = descriptor.getVersionPropertyName() != null ? Reflections.getGetterMethod(this.getBeanClass(), descriptor.getVersionPropertyName()) : null;
        }
        if (descriptor == null || !descriptor.isMetaDataComplete()) {
            Class<?> clazz = this.getBeanClass();
            while (clazz != Object.class) {
                AccessibleObject[] accessibleObjectArray = clazz.getDeclaredMethods();
                int n = accessibleObjectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = accessibleObjectArray[n2];
                    if (this.preRemoveMethod == null && method.isAnnotationPresent(PreRemove.class)) {
                        this.preRemoveMethod = method;
                    }
                    if (this.prePersistMethod == null && method.isAnnotationPresent(PrePersist.class)) {
                        this.prePersistMethod = method;
                    }
                    if (this.preUpdateMethod == null && method.isAnnotationPresent(PreUpdate.class)) {
                        this.preUpdateMethod = method;
                    }
                    if (this.postLoadMethod == null && method.isAnnotationPresent(PostLoad.class)) {
                        this.postLoadMethod = method;
                    }
                    if (this.identifierField == null && this.identifierGetter == null && method.isAnnotationPresent(Id.class) || method.isAnnotationPresent(EmbeddedId.class)) {
                        this.identifierGetter = method;
                    }
                    if (this.versionField == null && this.versionGetter == null && method.isAnnotationPresent(Version.class)) {
                        this.versionGetter = method;
                    }
                    ++n2;
                }
                if (this.identifierGetter == null && this.identifierField == null || this.versionField == null && this.versionGetter == null) {
                    accessibleObjectArray = clazz.getDeclaredFields();
                    n = accessibleObjectArray.length;
                    n2 = 0;
                    while (n2 < n) {
                        AccessibleObject field = accessibleObjectArray[n2];
                        if (this.identifierGetter == null && this.identifierField == null && (field.isAnnotationPresent(Id.class) || field.isAnnotationPresent(EmbeddedId.class))) {
                            this.identifierField = field;
                        }
                        if (this.versionGetter == null && this.versionField == null && field.isAnnotationPresent(Version.class)) {
                            this.versionField = field;
                        }
                        ++n2;
                    }
                }
                clazz = clazz.getSuperclass();
            }
        }
        this.setAccessible(this.preRemoveMethod);
        this.setAccessible(this.prePersistMethod);
        this.setAccessible(this.preUpdateMethod);
        this.setAccessible(this.postLoadMethod);
        this.setAccessible(this.identifierField);
        this.setAccessible(this.identifierGetter);
        this.setAccessible(this.versionField);
        this.setAccessible(this.versionGetter);
    }

    private void setAccessible(AccessibleObject accessibleObject) {
        if (accessibleObject != null) {
            accessibleObject.setAccessible(true);
        }
    }

    private static String lookupName(Class<?> beanClass, EjbEntityDescriptor descriptor) {
        if (descriptor != null && descriptor.getEjbName() != null) {
            return descriptor.getEjbName();
        }
        if (!(descriptor != null && descriptor.isMetaDataComplete() || !beanClass.isAnnotationPresent(javax.persistence.Entity.class) || "".equals(beanClass.getAnnotation(javax.persistence.Entity.class).name()))) {
            return beanClass.getAnnotation(javax.persistence.Entity.class).name();
        }
        if (descriptor != null || beanClass.isAnnotationPresent(javax.persistence.Entity.class)) {
            return beanClass.getName();
        }
        return null;
    }

    private static Method getEntityCallbackMethod(Class beanClass, String callbackMethodName) {
        try {
            if (callbackMethodName != null) {
                return Reflections.getMethod(beanClass, callbackMethodName);
            }
            return null;
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Unable to find Entity callback method specified in orm.xml", e);
        }
    }

    public static /* bridge */ /* synthetic */ Model forClass(Class clazz) {
        return Entity.forClass(clazz);
    }

    public static class NotEntityException
    extends IllegalArgumentException {
        public NotEntityException(String string) {
            super(string);
        }
    }
}

