/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class CyclicDependencyException
extends IllegalStateException {
    private final List<String> invocations = new ArrayList<String>();
    private String tailComponentName;
    private boolean cycleComplete;

    public void addInvocation(String componentName, Method method) {
        if (this.cycleComplete) {
            return;
        }
        if (this.invocations.isEmpty()) {
            this.tailComponentName = componentName;
        } else if (this.tailComponentName.equals(componentName)) {
            this.cycleComplete = true;
        }
        this.invocations.add(this.createInvocationLabel(componentName, method));
    }

    private String createInvocationLabel(String componentName, Method method) {
        String invocationLabel = String.valueOf(componentName) + "." + method.getName() + "(";
        int i = 1;
        Class<?>[] classArray = method.getParameterTypes();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> parameterType = classArray[n2];
            invocationLabel = String.valueOf(invocationLabel) + parameterType.getSimpleName();
            if (i < method.getParameterTypes().length) {
                invocationLabel = String.valueOf(invocationLabel) + ", ";
            }
            ++i;
            ++n2;
        }
        invocationLabel = String.valueOf(invocationLabel) + ")";
        return invocationLabel;
    }

    public String getMessage() {
        if (!this.cycleComplete) {
            return "Cyclic dependency found";
        }
        String message = "Injection into " + this.tailComponentName + " resulted in a dependency cycle, requiring the invocation of " + this.invocations.get(0) + ".  The complete cycle: ";
        int i = this.invocations.size() - 1;
        while (i >= 0) {
            message = String.valueOf(message) + this.invocations.get(i);
            if (i != 0) {
                message = String.valueOf(message) + " -> ";
            }
            --i;
        }
        return message;
    }
}

