/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.async;

import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.async.AbstractDispatcher;
import org.jboss.seam.async.Asynchronous;
import org.jboss.seam.async.AsynchronousEvent;
import org.jboss.seam.async.AsynchronousInvocation;
import org.jboss.seam.async.TimerSchedule;
import org.jboss.seam.intercept.InvocationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.APPLICATION)
@Name(value="org.jboss.seam.async.dispatcher")
@Install(precedence=0)
public class ThreadPoolDispatcher
extends AbstractDispatcher<Future, TimerSchedule> {
    private int threadPoolSize = 10;
    private ScheduledExecutorService executor;

    @Create
    public void startup() {
        this.executor = Executors.newScheduledThreadPool(this.threadPoolSize);
    }

    @Override
    public Future scheduleAsynchronousEvent(String type, Object ... parameters) {
        RunnableAsynchronous runnableAsynchronous = new RunnableAsynchronous(new AsynchronousEvent(type, parameters));
        Future<?> future = this.executor.submit(runnableAsynchronous);
        runnableAsynchronous.setFuture(future);
        return future;
    }

    @Override
    public Future scheduleTimedEvent(String type, TimerSchedule schedule, Object ... parameters) {
        return this.scheduleWithExecutorService(schedule, new RunnableAsynchronous(new AsynchronousEvent(type, parameters)));
    }

    @Override
    public Future scheduleInvocation(InvocationContext invocation, Component component) {
        return this.scheduleWithExecutorService(this.createTimerSchedule(invocation), new RunnableAsynchronous(new AsynchronousInvocation(invocation, component)));
    }

    private static long toDuration(Date expiration) {
        return expiration.getTime() - new Date().getTime();
    }

    private Future scheduleWithExecutorService(TimerSchedule schedule, RunnableAsynchronous runnable) {
        ScheduledFuture<?> future = null;
        future = schedule.getIntervalDuration() != null ? (schedule.getExpiration() != null ? this.executor.scheduleAtFixedRate(runnable, ThreadPoolDispatcher.toDuration(schedule.getExpiration()), schedule.getIntervalDuration(), TimeUnit.MILLISECONDS) : (schedule.getDuration() != null ? this.executor.scheduleAtFixedRate(runnable, schedule.getDuration(), schedule.getIntervalDuration(), TimeUnit.MILLISECONDS) : this.executor.scheduleAtFixedRate(runnable, 0L, schedule.getIntervalDuration(), TimeUnit.MILLISECONDS))) : (schedule.getExpiration() != null ? this.executor.schedule(runnable, ThreadPoolDispatcher.toDuration(schedule.getExpiration()), TimeUnit.MILLISECONDS) : (schedule.getDuration() != null ? this.executor.schedule(runnable, (long)schedule.getDuration(), TimeUnit.MILLISECONDS) : this.executor.schedule(runnable, 0L, TimeUnit.MILLISECONDS)));
        runnable.setFuture(future);
        return future;
    }

    @Destroy
    public void destroy() {
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int getThreadPoolSize() {
        return this.threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.threadPoolSize = threadPoolSize;
    }

    static class RunnableAsynchronous
    implements Runnable {
        private Asynchronous async;
        private Future future;

        RunnableAsynchronous(Asynchronous async) {
            this.async = async;
        }

        public void run() {
            try {
                this.async.execute(this.future);
            }
            catch (Exception exception) {
                this.async.handleException(exception, this.future);
            }
        }

        public void setFuture(Future future) {
            this.future = future;
        }
    }
}

